/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jtransfo.AutomaticListTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.object.AbstractHumanDomain;
import org.jtransfo.object.AbstractHumanTo;
import org.jtransfo.object.FemaleHumanDomain;
import org.jtransfo.object.FemaleHumanTo;
import org.jtransfo.object.HouseDomain;
import org.jtransfo.object.HouseTo;
import org.jtransfo.object.MaleHumanDomain;
import org.jtransfo.object.MaleHumanTo;
import org.junit.Before;
import org.junit.Test;

public class AutomaticListTypeConverterTest {
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        this.jTransfo = new JTransfoImpl();
        ((JTransfoImpl)this.jTransfo).getTypeConverters().add(new AutomaticListTypeConverter());
        ((JTransfoImpl)this.jTransfo).updateTypeConverters();
    }

    @Test
    public void testCanConvert() throws Exception {
        AutomaticListTypeConverter typeConverter = new AutomaticListTypeConverter(this.jTransfo);
        Assertions.assertThat((boolean)typeConverter.canConvert(List.class, List.class)).isFalse();
    }

    @Test
    public void testConvertDomainObject() throws Exception {
        HouseDomain hd = new HouseDomain();
        MaleHumanDomain owner = new MaleHumanDomain();
        owner.setName("the owner");
        owner.setWeeklyPubVisits(4);
        MaleHumanDomain id1 = new MaleHumanDomain();
        id1.setName("male inhabitant");
        id1.setWeeklyPubVisits(0);
        FemaleHumanDomain id2 = new FemaleHumanDomain();
        id2.setName("female inhabitant");
        id2.setHairColourCount(1);
        ArrayList<AbstractHumanDomain> inhabitants = new ArrayList<AbstractHumanDomain>();
        inhabitants.add(id1);
        inhabitants.add(id2);
        hd.setOwner(owner);
        hd.setInhabitants(inhabitants);
        HouseTo ht = (HouseTo)this.jTransfo.convert((Object)hd, (Object)new HouseTo(), new String[0]);
        Assertions.assertThat((Object)ht.getOwner()).isNotNull();
        Assertions.assertThat((Object)ht.getOwner()).isInstanceOf(MaleHumanTo.class);
        Assertions.assertThat((String)ht.getOwner().getName()).isEqualTo((Object)"the owner");
        Assertions.assertThat((int)((MaleHumanTo)ht.getOwner()).getWeeklyPubVisits()).isEqualTo(4);
        ((ListAssert)Assertions.assertThat(ht.getInhabitants()).hasSize(2)).extracting("name").contains(new Object[]{"male inhabitant", "female inhabitant"});
        Assertions.assertThat((Object)ht.getInhabitants().get(0)).isInstanceOf(MaleHumanTo.class);
        Assertions.assertThat((int)((MaleHumanTo)ht.getInhabitants().get(0)).getWeeklyPubVisits()).isEqualTo(0);
        Assertions.assertThat((Object)ht.getInhabitants().get(1)).isInstanceOf(FemaleHumanTo.class);
        Assertions.assertThat((int)((FemaleHumanTo)ht.getInhabitants().get(1)).getHairColourCount()).isEqualTo(1);
    }

    @Test
    public void testConvertTransferObject() throws Exception {
        HouseTo ht = new HouseTo();
        MaleHumanTo owner = new MaleHumanTo();
        owner.setName("the owner");
        owner.setWeeklyPubVisits(4);
        MaleHumanTo it1 = new MaleHumanTo();
        it1.setName("male inhabitant");
        it1.setWeeklyPubVisits(0);
        FemaleHumanTo it2 = new FemaleHumanTo();
        it2.setName("female inhabitant");
        it2.setHairColourCount(1);
        ArrayList<AbstractHumanTo> inhabitants = new ArrayList<AbstractHumanTo>();
        inhabitants.add(it1);
        inhabitants.add(it2);
        ht.setOwner(owner);
        ht.setInhabitants(inhabitants);
        HouseDomain hd = (HouseDomain)this.jTransfo.convert((Object)ht, (Object)new HouseDomain(), new String[0]);
        Assertions.assertThat((Object)hd.getOwner()).isNotNull();
        Assertions.assertThat((Object)hd.getOwner()).isInstanceOf(MaleHumanDomain.class);
        Assertions.assertThat((String)hd.getOwner().getName()).isEqualTo((Object)"the owner");
        Assertions.assertThat((int)((MaleHumanDomain)hd.getOwner()).getWeeklyPubVisits()).isEqualTo(4);
        ((ListAssert)Assertions.assertThat(hd.getInhabitants()).hasSize(2)).extracting("name").contains(new Object[]{"male inhabitant", "female inhabitant"});
        Assertions.assertThat((Object)hd.getInhabitants().get(0)).isInstanceOf(MaleHumanDomain.class);
        Assertions.assertThat((int)((MaleHumanDomain)hd.getInhabitants().get(0)).getWeeklyPubVisits()).isEqualTo(0);
        Assertions.assertThat((Object)hd.getInhabitants().get(1)).isInstanceOf(FemaleHumanDomain.class);
        Assertions.assertThat((int)((FemaleHumanDomain)hd.getInhabitants().get(1)).getHairColourCount()).isEqualTo(1);
    }
}

