/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.ConvertSourceTarget;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.NeedsJTransfo;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.ObjectFinder;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ConverterHelper;
import org.jtransfo.internal.NewInstanceObjectFinder;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.object.PersonTo;
import org.jtransfo.object.SimpleClassDomain;
import org.jtransfo.object.SimpleClassNameTo;
import org.jtransfo.object.SimpleClassTypeTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class JTransfoImplTest {
    private JTransfoImpl jTransfo;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Mock
    private ConverterHelper converterHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.jTransfo = new JTransfoImpl();
        ReflectionTestUtils.setField(this.jTransfo.getObjectFinders().get(0), (String)"reflectionHelper", (Object)this.reflectionHelper);
    }

    @Test
    public void testConvertNull() {
        Assertions.assertThat((Object)this.jTransfo.convert(null)).isNull();
    }

    @Test
    public void testConvert2NullLeft() {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Source and target are required to be not-null.");
        this.jTransfo.convert((Object)"bla", null, new String[0]);
    }

    @Test
    public void testConvert2NullRight() {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Source and target are required to be not-null.");
        this.jTransfo.convert(null, (Object)"bla", new String[0]);
    }

    @Test
    public void testConvert2DomainClass() {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Neither source nor target are annotated with DomainClass on classes java.lang.String and java.lang.String.");
        this.jTransfo.convert((Object)"alb", (Object)"bla", new String[0]);
    }

    @Test
    public void testConvertToNull() {
        Assertions.assertThat((Object)this.jTransfo.convertTo(null, this.getClass(), new String[0])).isNull();
    }

    @Test
    public void testFindTargetNull() {
        Assertions.assertThat((Object)this.jTransfo.findTarget(null, this.getClass())).isNull();
    }

    @Test
    public void testConvertInstantiationException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.convert((Object)new SimpleClassNameTo());
    }

    @Test
    public void testConvertToInstantiationException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.convertTo((Object)new SimpleClassNameTo(), SimpleClassDomain.class, new String[0]);
    }

    @Test
    public void testFindTargetInstantiationException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.findTarget((Object)new SimpleClassNameTo(), SimpleClassDomain.class);
    }

    @Test
    public void testConvertIllegalAccessException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.convert((Object)new SimpleClassNameTo());
    }

    @Test
    public void testConvertToIllegalAccessException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.convertTo((Object)new SimpleClassNameTo(), SimpleClassDomain.class, new String[0]);
    }

    @Test
    public void testFindTargetIllegalAccessException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.jTransfo.findTarget((Object)new SimpleClassNameTo(), SimpleClassDomain.class);
    }

    @Test
    public void testConvertNullTarget() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenReturn(null);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of target class org.jtransfo.object.SimpleClassDomain for source object org.jtransfo.object.SimpleClassNameTo");
        this.jTransfo.convert((Object)new SimpleClassNameTo());
    }

    @Test
    public void testGetUpdateTypeConverters() throws Exception {
        ReflectionTestUtils.setField((Object)this.jTransfo, (String)"converterHelper", (Object)this.converterHelper);
        List converters = this.jTransfo.getTypeConverters();
        int orgSize = converters.size();
        converters.add(new NoConversionTypeConverter());
        NeedsJTransfoTypeConverter needsJTransfoTypeConverter = (NeedsJTransfoTypeConverter)Mockito.mock(NeedsJTransfoTypeConverter.class);
        converters.add(needsJTransfoTypeConverter);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.converterHelper});
        this.jTransfo.updateTypeConverters();
        ((NeedsJTransfoTypeConverter)Mockito.verify((Object)needsJTransfoTypeConverter)).setJTransfo((JTransfo)this.jTransfo);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(Collection.class);
        ((ConverterHelper)Mockito.verify((Object)this.converterHelper, (VerificationMode)Mockito.times((int)1))).setTypeConvertersInOrder((Collection)captor1.capture());
        Assertions.assertThat((int)((Collection)captor1.getValue()).size()).isEqualTo(orgSize + 2);
        Mockito.reset((Object[])new ConverterHelper[]{this.converterHelper});
        this.jTransfo.updateTypeConverters(Collections.singletonList(new NoConversionTypeConverter()));
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Collection.class);
        ((ConverterHelper)Mockito.verify((Object)this.converterHelper, (VerificationMode)Mockito.times((int)1))).setTypeConvertersInOrder((Collection)captor2.capture());
        Assertions.assertThat((int)((Collection)captor2.getValue()).size()).isEqualTo(1);
    }

    @Test
    public void testGetUpdateObjectFinders() throws Exception {
        List objectFinders = this.jTransfo.getObjectFinders();
        int orgSize = objectFinders.size();
        objectFinders.add(new NewInstanceObjectFinder());
        List internalObjectFinders = (List)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"objectFinders");
        Assertions.assertThat((List)internalObjectFinders).hasSize(orgSize);
        this.jTransfo.updateObjectFinders();
        internalObjectFinders = (List)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"objectFinders");
        Assertions.assertThat((List)internalObjectFinders).hasSize(orgSize + 1);
        this.jTransfo.updateObjectFinders(Collections.singletonList(new NewInstanceObjectFinder()));
        internalObjectFinders = (List)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"objectFinders");
        Assertions.assertThat((List)internalObjectFinders).hasSize(1);
    }

    @Test
    public void testGetUpdateConvertInterceptors() throws Exception {
        List convertInterceptors = this.jTransfo.getConvertInterceptors();
        ConvertSourceTarget convertInterceptorChain = (ConvertSourceTarget)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain");
        convertInterceptors.add(new ConvertInterceptor(){

            public <T> T convert(Object source, T target, boolean isTargetTo, ConvertSourceTarget next, String ... tags) {
                return (T)next.convert(source, target, isTargetTo, tags);
            }
        });
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain")).isEqualTo((Object)convertInterceptorChain);
        this.jTransfo.updateConvertInterceptors();
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain")).isNotEqualTo((Object)convertInterceptorChain);
    }

    @Test
    public void testGetUpdateConvertInterceptors_newList() throws Exception {
        ArrayList<2> convertInterceptors = new ArrayList<2>();
        ConvertSourceTarget convertInterceptorChain = (ConvertSourceTarget)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain");
        convertInterceptors.add(new ConvertInterceptor(){

            public <T> T convert(Object source, T target, boolean isTargetTo, ConvertSourceTarget next, String ... tags) {
                return (T)next.convert(source, target, isTargetTo, tags);
            }
        });
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain")).isEqualTo((Object)convertInterceptorChain);
        this.jTransfo.updateConvertInterceptors(convertInterceptors);
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)this.jTransfo, (String)"convertInterceptorChain")).isNotEqualTo((Object)convertInterceptorChain);
    }

    @Test
    public void testFindTarget() throws Exception {
        SimpleClassNameTo to = new SimpleClassNameTo();
        SimpleClassDomain target = (SimpleClassDomain)Mockito.mock(SimpleClassDomain.class);
        ObjectFinder objectFinder = (ObjectFinder)Mockito.mock(ObjectFinder.class);
        Mockito.when((Object)objectFinder.getObject(SimpleClassDomain.class, (Object)to)).thenReturn((Object)target);
        this.jTransfo.updateObjectFinders(Collections.singletonList(objectFinder));
        SimpleClassDomain res = (SimpleClassDomain)this.jTransfo.findTarget((Object)to, SimpleClassDomain.class);
        ((ObjectFinder)Mockito.verify((Object)objectFinder)).getObject(SimpleClassDomain.class, (Object)to);
        Assertions.assertThat((Object)res).isEqualTo((Object)target);
    }

    @Test
    public void isToClassTest() throws Exception {
        Assertions.assertThat((boolean)this.jTransfo.isToClass(SimpleClassNameTo.class)).isTrue();
        Assertions.assertThat((boolean)this.jTransfo.isToClass(SimpleClassTypeTo.class)).isTrue();
        Assertions.assertThat((boolean)this.jTransfo.isToClass(SimpleClassDomain.class)).isFalse();
    }

    @Test
    public void testConvertList() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassNameTo.class)).thenReturn((Object)new SimpleClassNameTo());
        ArrayList<SimpleClassDomain> list = new ArrayList<SimpleClassDomain>();
        list.add(new SimpleClassDomain());
        list.add(new SimpleClassDomain());
        List res = this.jTransfo.convertList(list, SimpleClassNameTo.class, new String[0]);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)res).isNotNull()).isNotEmpty()).hasSize(2);
        Assertions.assertThat(res.get(0)).isInstanceOf(SimpleClassNameTo.class);
    }

    @Test
    public void testConvertListNull() {
        Assertions.assertThat((List)this.jTransfo.convertList(null, SimpleClassNameTo.class, new String[0])).isNull();
    }

    @Test
    public void testConvert_passTags() throws Exception {
        ConvertSourceTarget cst = (ConvertSourceTarget)Mockito.mock(ConvertSourceTarget.class);
        ReflectionTestUtils.setField((Object)this.jTransfo, (String)"convertInterceptorChain", (Object)cst);
        PersonTo source = new PersonTo();
        Object target = Mockito.mock(Object.class);
        String[] tags = new String[]{"bla"};
        this.jTransfo.convert((Object)source, target, tags);
        ((ConvertSourceTarget)Mockito.verify((Object)cst)).convert((Object)source, target, false, tags);
    }

    @Test
    public void testConvert_noTags() throws Exception {
        ConvertSourceTarget cst = (ConvertSourceTarget)Mockito.mock(ConvertSourceTarget.class);
        ReflectionTestUtils.setField((Object)this.jTransfo, (String)"convertInterceptorChain", (Object)cst);
        PersonTo source = new PersonTo();
        Object target = Mockito.mock(Object.class);
        this.jTransfo.convert((Object)source, target, new String[0]);
        ((ConvertSourceTarget)Mockito.verify((Object)cst)).convert((Object)source, target, false, new String[]{"\u00a7#noTags"});
    }

    @Test
    public void clearCaches() throws Exception {
        this.jTransfo.clearCaches();
    }

    private static interface NeedsJTransfoTypeConverter
    extends TypeConverter,
    NeedsJTransfo {
    }
}

