/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jtransfo.JTransfoException;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.SyntheticField;

public class StringEnumTypeConverter<ENUM_TYPE extends Enum>
implements TypeConverter<String, ENUM_TYPE> {
    private final Class<ENUM_TYPE> enumClass;

    public StringEnumTypeConverter(Class<ENUM_TYPE> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        Class<?> toType = this.getClass(realToType);
        Class<?> domainType = this.getClass(realDomainType);
        return String.class.isAssignableFrom(toType) && this.enumClass.isAssignableFrom(domainType);
    }

    @Override
    public ENUM_TYPE convert(String object, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
        if (null == object || 0 == object.length()) {
            return null;
        }
        return Enum.valueOf(this.enumClass, object);
    }

    @Override
    public String reverse(ENUM_TYPE object, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
        if (null == object) {
            return null;
        }
        return ((Enum)object).name();
    }

    private Class<?> getClass(Type type) {
        return type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
    }
}

