/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jtransfo.JTransfoException;
import org.jtransfo.MapOnlies;
import org.jtransfo.MapOnly;
import org.jtransfo.MappedBy;
import org.jtransfo.Named;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.NotMapped;
import org.jtransfo.ToConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.LockableList;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.TaggedConverter;
import org.jtransfo.internal.ToDomainConverter;
import org.jtransfo.internal.ToToConverter;

public class ConverterHelper {
    private static final String DECLARED_TYPE_CONVERTER_CLASS = "Declared TypeConverter class ";
    private ReflectionHelper reflectionHelper = new ReflectionHelper();
    private ConcurrentHashMap<String, TypeConverter> typeConverterInstances = new ConcurrentHashMap();
    private List<TypeConverter> typeConvertersInOrder = Collections.emptyList();

    public ToConverter getToConverter(Class toClass, Class domainClass) throws JTransfoException {
        ToConverter converter = new ToConverter();
        List<SyntheticField> domainFields = this.reflectionHelper.getSyntheticFields(domainClass);
        for (Field field : this.reflectionHelper.getFields(toClass)) {
            boolean isStatic;
            boolean isTransient = Modifier.isTransient(field.getModifiers());
            NotMapped notMapped = field.getAnnotation(NotMapped.class);
            if (isTransient || null != notMapped) continue;
            MappedBy mappedBy = field.getAnnotation(MappedBy.class);
            boolean bl = isStatic = 0 != (field.getModifiers() & 8);
            if (null == mappedBy && isStatic) continue;
            this.buildConverters(field, domainFields, domainClass, converter, mappedBy);
        }
        return converter;
    }

    private SyntheticField[] getDomainField(Field field, List<SyntheticField> domainFields, Class domainClass, String fieldParam, String pathParam, boolean readOnlyParam) {
        SyntheticField[] domainField;
        boolean readOnlyField;
        String domainFieldName = field.getName();
        String[] domainFieldPath = new String[]{};
        boolean bl = readOnlyField = 0 != (field.getModifiers() & 0x10) || readOnlyParam;
        if (!"?".equals(fieldParam)) {
            domainFieldName = fieldParam;
        }
        if (!"".equals(pathParam)) {
            domainFieldPath = pathParam.split("\\.");
        }
        try {
            domainField = this.findField(domainFields, domainFieldName, domainFieldPath, domainClass, readOnlyField);
        }
        catch (JTransfoException jte) {
            throw new JTransfoException(String.format("Cannot determine mapping for field %s in class %s. The field %s in class %s %scannot be found.", field.getName(), field.getDeclaringClass().getName(), domainFieldName, domainClass.getName(), this.withPath(domainFieldPath)), jte);
        }
        return domainField;
    }

    private SyntheticField[] getDomainField(Field field, List<SyntheticField> domainFields, Class domainClass, MappedBy mappedBy) {
        if (null == mappedBy) {
            return this.getDomainField(field, domainFields, domainClass, "?", "", false);
        }
        return this.getDomainField(field, domainFields, domainClass, mappedBy.field(), mappedBy.path(), mappedBy.readOnly());
    }

    private void buildConverters(Field field, List<SyntheticField> domainFields, Class domainClass, ToConverter converter, MappedBy mappedBy) {
        SimpleSyntheticField sField = new SimpleSyntheticField(field);
        List<MapOnly> mapOnlies = this.getMapOnlies(field);
        if (null == mapOnlies) {
            SyntheticField[] domainField = this.getDomainField(field, domainFields, domainClass, mappedBy);
            TypeConverter typeConverter = this.getDeclaredTypeConverter(mappedBy);
            if (null == typeConverter) {
                typeConverter = this.getDefaultTypeConverter(field.getGenericType(), domainField[domainField.length - 1].getGenericType());
            }
            if (0 == (field.getModifiers() & 0x10)) {
                converter.getToTo().add(new ToToConverter(sField, domainField, typeConverter));
            }
            if (null == mappedBy || !mappedBy.readOnly()) {
                converter.getToDomain().add(new ToDomainConverter(sField, domainField, typeConverter));
            }
        } else {
            TaggedConverter toTo = new TaggedConverter();
            TaggedConverter toDomain = new TaggedConverter();
            converter.getToTo().add(toTo);
            converter.getToDomain().add(toDomain);
            for (MapOnly mapOnly : mapOnlies) {
                TypeConverter typeConverter;
                SyntheticField[] mapOnlyDomainField = null;
                if (!"".equals(mapOnly.path()) || !"?".equals(mapOnly.field())) {
                    mapOnlyDomainField = this.getDomainField(field, domainFields, domainClass, mapOnly.field(), mapOnly.path(), mapOnly.readOnly());
                }
                if (null == mapOnlyDomainField) {
                    mapOnlyDomainField = this.getDomainField(field, domainFields, domainClass, mappedBy);
                }
                if (null == (typeConverter = this.getDeclaredTypeConverter(mappedBy))) {
                    typeConverter = this.getDefaultTypeConverter(field.getGenericType(), mapOnlyDomainField[mapOnlyDomainField.length - 1].getGenericType());
                }
                TypeConverter moTypeConverter = this.getDeclaredTypeConverter(mapOnly, typeConverter);
                ToToConverter ttc = new ToToConverter(sField, mapOnlyDomainField, moTypeConverter);
                toTo.addConverters(mapOnly.value(), ttc);
                if (mapOnly.readOnly()) continue;
                ToDomainConverter tdc = new ToDomainConverter(sField, mapOnlyDomainField, moTypeConverter);
                toDomain.addConverters(mapOnly.value(), tdc);
            }
        }
    }

    protected List<MapOnly> getMapOnlies(Field field) {
        MapOnly mapOnly = field.getAnnotation(MapOnly.class);
        MapOnlies mapOnlies = field.getAnnotation(MapOnlies.class);
        if (null == mapOnly && null == mapOnlies) {
            return null;
        }
        ArrayList<MapOnly> res = new ArrayList<MapOnly>();
        if (null != mapOnly) {
            res.add(mapOnly);
        }
        if (null != mapOnlies) {
            Collections.addAll(res, mapOnlies.value());
        }
        return res;
    }

    public String withPath(String[] path) {
        StringBuilder sb = new StringBuilder();
        if (path.length > 0) {
            sb.append(" (with path ");
            for (int i = 0; i < path.length - 1; ++i) {
                sb.append(path[i]);
                sb.append(".");
            }
            sb.append(path[path.length - 1]);
            sb.append(") ");
        }
        return sb.toString();
    }

    protected SyntheticField[] findField(List<SyntheticField> domainFields, String fieldName, String[] path, Class<?> type, boolean readOnlyField) throws JTransfoException {
        List<SyntheticField> fields = domainFields;
        SyntheticField[] result = new SyntheticField[path.length + 1];
        Class<?> currentType = type;
        for (int index = 0; index < path.length; ++index) {
            boolean found = false;
            for (SyntheticField field : fields) {
                if (!field.getName().equals(path[index])) continue;
                found = true;
                result[index] = field;
                break;
            }
            if (!found) {
                result[index] = new AccessorSyntheticField(this.reflectionHelper, currentType, path[index], readOnlyField);
            }
            currentType = result[index].getType();
            fields = this.reflectionHelper.getSyntheticFields(currentType);
        }
        for (SyntheticField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            result[index] = field;
            return result;
        }
        result[index] = new AccessorSyntheticField(this.reflectionHelper, currentType, fieldName, readOnlyField);
        return result;
    }

    protected TypeConverter getDeclaredTypeConverter(String typeConverterClassName1, String typeConverterClassName2) {
        String typeConverterClass = typeConverterClassName1;
        if (MappedBy.DefaultTypeConverter.class.getName().equals(typeConverterClass)) {
            typeConverterClass = typeConverterClassName2;
        }
        if (!"?".equals(typeConverterClass)) {
            TypeConverter typeConverter = this.typeConverterInstances.get(typeConverterClass);
            if (null == typeConverter) {
                try {
                    typeConverter = (TypeConverter)this.reflectionHelper.newInstance(typeConverterClass);
                    this.typeConverterInstances.put(typeConverterClass, typeConverter);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be found.", cnfe);
                }
                catch (InstantiationException ie) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be instantiated.", ie);
                }
                catch (IllegalAccessException iae) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be accessed.", iae);
                }
                catch (ClassCastException cce) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be cast to a TypeConverter.", cce);
                }
            }
            return typeConverter;
        }
        return null;
    }

    protected TypeConverter getDeclaredTypeConverter(MappedBy mappedBy) {
        if (null == mappedBy) {
            return null;
        }
        return this.getDeclaredTypeConverter(mappedBy.typeConverterClass().getName(), mappedBy.typeConverter());
    }

    protected TypeConverter getDeclaredTypeConverter(MapOnly mapOnly, TypeConverter fallback) {
        TypeConverter typeConverter;
        if (null != mapOnly && null != (typeConverter = this.getDeclaredTypeConverter(mapOnly.typeConverterClass().getName(), mapOnly.typeConverter()))) {
            return typeConverter;
        }
        return fallback;
    }

    public void setTypeConvertersInOrder(Collection<TypeConverter> typeConverters) {
        LockableList<TypeConverter> newList = new LockableList<TypeConverter>();
        newList.addAll(typeConverters);
        newList.lock();
        this.typeConvertersInOrder = newList;
        for (TypeConverter tc : newList) {
            String name = null;
            if (tc instanceof Named) {
                name = ((Named)((Object)tc)).getName();
            }
            if (null == name) {
                name = tc.getClass().getName();
            }
            this.typeConverterInstances.put(name, tc);
        }
    }

    protected TypeConverter getDefaultTypeConverter(Type toField, Type domainField) {
        for (TypeConverter typeConverter : this.typeConvertersInOrder) {
            if (!typeConverter.canConvert(toField, domainField)) continue;
            return typeConverter;
        }
        return new NoConversionTypeConverter();
    }
}

