/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.jtransfo.JTransfoException;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.AbstractConverter;
import org.jtransfo.internal.SyntheticField;

public final class ToDomainConverter
extends AbstractConverter {
    private SyntheticField toField;
    private SyntheticField[] domainFields;
    private TypeConverter typeConverter;

    public ToDomainConverter(SyntheticField toField, SyntheticField[] domainFields, TypeConverter typeConverter) {
        this.toField = toField;
        this.domainFields = domainFields;
        this.typeConverter = typeConverter;
    }

    @Override
    public void doConvert(Object source, Object firstTarget, String ... tags) throws JTransfoException, IllegalAccessException, IllegalArgumentException {
        Object value = this.toField.get(source);
        Object target = firstTarget;
        for (int i = 0; i < this.domainFields.length - 1; ++i) {
            if (null != (target = this.domainFields[i].get(target))) continue;
            throw new JTransfoException(String.format("Cannot convert TO field %s to domain field %s, transitive field %s in path is null.", this.toField.getName(), this.domainFieldName(this.domainFields), this.domainFields[i].getName()));
        }
        SyntheticField domainField = this.domainFields[this.domainFields.length - 1];
        domainField.set(target, this.typeConverter.convert(value, domainField, target, tags));
    }

    @Override
    public String accessExceptionMessage() {
        return String.format("Cannot convert TO field %s to domain field %s, field cannot be accessed.", this.toField.getName(), this.domainFieldName(this.domainFields));
    }

    @Override
    public String argumentExceptionMessage() {
        return String.format("Cannot convert TO field %s to domain field %s, field needs type conversion.", this.toField.getName(), this.domainFieldName(this.domainFields));
    }
}

