/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.ObjectReplacer;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleBaseTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class JTransfoImplObjectReplacerTest {
    private JTransfo jTransfo;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        JTransfoImpl impl = new JTransfoImpl();
        this.jTransfo = impl;
        impl.getObjectReplacers().add(new MyObjectReplacer());
        impl.updateObjectReplacers();
    }

    @Test
    public void testAdditionalReplacer() throws Exception {
        ObjectReplacer mockReplacer = (ObjectReplacer)Mockito.mock(ObjectReplacer.class);
        ((JTransfoImpl)this.jTransfo).updateObjectReplacers(Collections.singletonList(mockReplacer));
        Assertions.assertThat((List)((JTransfoImpl)this.jTransfo).getObjectReplacers()).contains((Object[])new ObjectReplacer[]{mockReplacer});
    }

    @Test
    public void testToToNoDelegate() throws Exception {
        SimpleBaseDomain domain = new SimpleBaseDomain();
        domain.setA("aaa");
        domain.setB("bb");
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert domain field");
        this.jTransfo.convertTo((Object)new DelegateTwo(domain), SimpleBaseTo.class, new String[0]);
    }

    @Test
    public void testToToWithDelegate() throws Exception {
        SimpleBaseDomain domain = new SimpleBaseDomain();
        domain.setA("aaa");
        domain.setB("bb");
        SimpleBaseTo res = (SimpleBaseTo)this.jTransfo.convertTo((Object)new DelegateOne(domain), SimpleBaseTo.class, new String[0]);
        Assertions.assertThat((Object)res).isNotNull();
        Assertions.assertThat((String)res.getA()).isEqualTo((Object)"aaa");
    }

    private class DelegateTwo {
        private SimpleBaseDomain delegate;

        public DelegateTwo(SimpleBaseDomain delegate) {
            this.delegate = delegate;
        }

        public String getA() throws IOException, JTransfoException, IllegalStateException {
            return this.delegate.getA();
        }

        public void setB(String b) {
            this.delegate.setB(b);
        }

        public String getB() {
            return this.delegate.getB();
        }

        public void setA(String a) throws IOException, JTransfoException, IllegalStateException {
            this.delegate.setA(a);
        }
    }

    private class DelegateOne {
        private SimpleBaseDomain delegate;

        public DelegateOne(SimpleBaseDomain delegate) {
            this.delegate = delegate;
        }

        public String getA() throws IOException, JTransfoException, IllegalStateException {
            return this.delegate.getA();
        }

        public void setB(String b) {
            this.delegate.setB(b);
        }

        public String getB() {
            return this.delegate.getB();
        }

        public void setA(String a) throws IOException, JTransfoException, IllegalStateException {
            this.delegate.setA(a);
        }
    }

    private class MyObjectReplacer
    implements ObjectReplacer {
        private MyObjectReplacer() {
        }

        public Object replaceObject(Object object) {
            if (object instanceof DelegateOne) {
                return ((DelegateOne)object).delegate;
            }
            return object;
        }
    }
}

