/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.ToHelper;

public class ReflectionHelper {
    public <T> T newInstance(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    public <T> T newInstance(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        return this.newInstance(this.loadClass(className));
    }

    public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = ToHelper.class.getClassLoader();
        }
        return cl.loadClass(name);
    }

    public List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (fieldNames.contains(field.getName())) continue;
                fieldNames.add(field.getName());
                this.makeAccessible(field);
                result.add(field);
            }
        }
        return result;
    }

    public List<SyntheticField> makeSynthetic(Class<?> clazz, List<Field> fields) {
        ArrayList<SyntheticField> result = new ArrayList<SyntheticField>();
        for (Field field : fields) {
            result.add(new AccessorSyntheticField(this, clazz, field));
        }
        return result;
    }

    public List<SyntheticField> getSyntheticFields(Class<?> clazz) {
        return this.makeSynthetic(clazz, this.getFields(clazz));
    }

    public void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public Method getMethod(Class<?> type, Class<?> returnType, String name, Class<?> ... parameters) {
        try {
            Method method = type.getMethod(name, parameters);
            if (null != returnType && !returnType.isAssignableFrom(method.getReturnType())) {
                method = null;
            }
            return method;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }
}

