/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.jtransfo.JTransfoException;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.AbstractConverter;
import org.jtransfo.internal.SyntheticField;

public final class ToToConverter
extends AbstractConverter {
    private SyntheticField toField;
    private SyntheticField[] domainFields;
    private TypeConverter typeConverter;

    public ToToConverter(SyntheticField toField, SyntheticField[] domainFields, TypeConverter typeConverter) {
        this.toField = toField;
        this.domainFields = domainFields;
        this.typeConverter = typeConverter;
    }

    @Override
    public void doConvert(Object source, Object target, String ... tags) throws JTransfoException, IllegalAccessException, IllegalArgumentException {
        Object value = source;
        for (SyntheticField field : this.domainFields) {
            if (null == value) continue;
            value = field.get(value);
        }
        Object converted = this.typeConverter.reverse(value, this.toField, target, tags);
        this.toField.set(target, converted);
    }

    @Override
    public String accessExceptionMessage() {
        return String.format("Cannot convert domain field %s to TO field %s, field cannot be accessed.", this.domainFieldName(this.domainFields), this.toField.getName());
    }

    @Override
    public String argumentExceptionMessage() {
        return String.format("Cannot convert domain field %s to TO field %s, field needs type conversion.", this.domainFieldName(this.domainFields), this.toField.getName());
    }
}

