/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jtransfo.AbstractSetTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AbstractSetTypeConverterTest {
    private static final String NAME = "cname";
    AbstractSetTypeConverter setTypeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private SyntheticField field;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setTypeConverter = new TestSetTypeConverter(NAME, AddressTo.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        this.setTypeConverter.setJTransfo(this.jTransfo);
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.setTypeConverter.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.setTypeConverter.canConvert(Set.class, Set.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(2L);
        AddressTo to2 = new AddressTo();
        to2.setId(1L);
        HashSet<AddressTo> addresses = new HashSet<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        Set resSet = (Set)Mockito.spy(new HashSet());
        Mockito.when((Object)this.field.get(domainObject)).thenReturn((Object)resSet);
        Set res = this.setTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
        ((Set)Mockito.verify((Object)resSet)).clear();
    }

    @Test
    public void testConvertGetFails() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(2L);
        AddressTo to2 = new AddressTo();
        to2.setId(1L);
        HashSet<AddressTo> addresses = new HashSet<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        Set resSet = (Set)Mockito.spy(new HashSet());
        Mockito.when((Object)this.field.get(domainObject)).thenThrow(new Throwable[]{new NullPointerException()});
        Set res = this.setTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
    }

    @Test
    public void testConvertNewSet() throws Exception {
        this.setTypeConverter.setAlwaysNewSet(true);
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        HashSet<AddressTo> addresses = new HashSet<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        Set res = this.setTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field, (VerificationMode)Mockito.times((int)0))).get(domainObject);
        res = this.setTypeConverter.convert(addresses, this.field, null, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field, (VerificationMode)Mockito.times((int)0))).get(domainObject);
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((Iterable)this.setTypeConverter.convert(null, this.field, null, new String[0])).isEmpty();
        this.setTypeConverter.setKeepNullSet(true);
        Assertions.assertThat((Iterable)this.setTypeConverter.convert(null, this.field, null, new String[0])).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        HashSet<AddressDomain> addresses = new HashSet<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        Set resSet = (Set)Mockito.spy(new HashSet());
        Mockito.when((Object)this.field.get(toObject)).thenReturn((Object)resSet);
        Set res = this.setTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
        ((Set)Mockito.verify((Object)resSet)).clear();
    }

    @Test
    public void testReverseGetFails() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        HashSet<AddressDomain> addresses = new HashSet<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        Mockito.when((Object)this.field.get(toObject)).thenThrow(new Throwable[]{new NullPointerException()});
        Set res = this.setTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(2);
        Assertions.assertThat((Iterable)res).extracting("id").contains(new Object[]{1L, 2L});
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
    }

    @Test
    public void testReverseNull() throws Exception {
        Assertions.assertThat((Iterable)this.setTypeConverter.reverse(null, this.field, null, new String[0])).isEmpty();
        this.setTypeConverter.setKeepNullSet(true);
        Assertions.assertThat((Iterable)this.setTypeConverter.reverse(null, this.field, null, new String[0])).isNull();
    }

    private class TestSetTypeConverter
    extends AbstractSetTypeConverter {
        private TestSetTypeConverter(String name, Class<?> toType) {
            super(name, toType);
        }

        public Object doConvertOne(JTransfo jTransfo, Object toObject, Class<?> domainObjectType, String ... tags) throws JTransfoException {
            if (toObject instanceof AddressTo) {
                long id = ((AddressTo)toObject).getId();
                AddressDomain address = new AddressDomain();
                address.setId(id);
                return address;
            }
            return null;
        }

        public Object doReverseOne(JTransfo jTransfo, Object domainObject, SyntheticField toField, Class<?> toType, String ... tags) throws JTransfoException {
            if (domainObject instanceof AddressDomain) {
                long id = ((AddressDomain)domainObject).getId();
                AddressTo address = new AddressTo();
                address.setId(id);
                return address;
            }
            return null;
        }
    }
}

