/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jtransfo.AutomaticSetTypeConverter;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.TypeConverter;
import org.jtransfo.object.AbstractHumanDomain;
import org.jtransfo.object.AbstractHumanTo;
import org.jtransfo.object.FemaleHumanDomain;
import org.jtransfo.object.FemaleHumanTo;
import org.jtransfo.object.FlatDomain;
import org.jtransfo.object.FlatTo;
import org.jtransfo.object.MaleHumanDomain;
import org.jtransfo.object.MaleHumanTo;
import org.junit.Before;
import org.junit.Test;

public class AutomaticSetTypeConverterTest {
    private ConfigurableJTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        this.jTransfo = JTransfoFactory.get();
        this.jTransfo.with((TypeConverter)new AutomaticSetTypeConverter());
    }

    @Test
    public void testWithName() throws Exception {
        AutomaticSetTypeConverter tc = new AutomaticSetTypeConverter("bla");
        Assertions.assertThat((String)tc.getName()).isEqualTo((Object)"bla");
    }

    @Test
    public void testNoExplicitName() throws Exception {
        AutomaticSetTypeConverter tc = new AutomaticSetTypeConverter();
        Assertions.assertThat((String)tc.getName()).isEqualTo((Object)"automaticSet");
    }

    @Test
    public void testCanConvert() throws Exception {
        AutomaticSetTypeConverter typeConverter = new AutomaticSetTypeConverter((JTransfo)this.jTransfo);
        Assertions.assertThat((boolean)typeConverter.canConvert(Set.class, Set.class)).isFalse();
    }

    @Test
    public void testConvertDomainObject() throws Exception {
        FlatDomain hd = new FlatDomain();
        MaleHumanDomain owner = new MaleHumanDomain();
        owner.setName("the owner");
        owner.setWeeklyPubVisits(4);
        MaleHumanDomain id1 = new MaleHumanDomain();
        id1.setName("male inhabitant");
        id1.setWeeklyPubVisits(0);
        FemaleHumanDomain id2 = new FemaleHumanDomain();
        id2.setName("female inhabitant");
        id2.setHairColourCount(1);
        HashSet<AbstractHumanDomain> inhabitants = new HashSet<AbstractHumanDomain>();
        inhabitants.add(id1);
        inhabitants.add(id2);
        hd.setOwner(owner);
        hd.setInhabitants(inhabitants);
        FlatTo ht = (FlatTo)this.jTransfo.convert((Object)hd, (Object)new FlatTo(), new String[0]);
        Assertions.assertThat((Object)ht.getOwner()).isNotNull();
        Assertions.assertThat((Object)ht.getOwner()).isInstanceOf(MaleHumanTo.class);
        Assertions.assertThat((String)ht.getOwner().getName()).isEqualTo((Object)"the owner");
        Assertions.assertThat((int)((MaleHumanTo)ht.getOwner()).getWeeklyPubVisits()).isEqualTo(4);
        ((IterableAssert)Assertions.assertThat(ht.getInhabitants()).hasSize(2)).extracting("name").contains(new Object[]{"male inhabitant", "female inhabitant"});
    }

    @Test
    public void testConvertTransferObject() throws Exception {
        FlatTo ht = new FlatTo();
        MaleHumanTo owner = new MaleHumanTo();
        owner.setName("the owner");
        owner.setWeeklyPubVisits(4);
        MaleHumanTo it1 = new MaleHumanTo();
        it1.setName("male inhabitant");
        it1.setWeeklyPubVisits(0);
        FemaleHumanTo it2 = new FemaleHumanTo();
        it2.setName("female inhabitant");
        it2.setHairColourCount(1);
        HashSet<AbstractHumanTo> inhabitants = new HashSet<AbstractHumanTo>();
        inhabitants.add(it1);
        inhabitants.add(it2);
        ht.setOwner(owner);
        ht.setInhabitants(inhabitants);
        FlatDomain hd = (FlatDomain)this.jTransfo.convert((Object)ht, (Object)new FlatDomain(), new String[0]);
        Assertions.assertThat((Object)hd.getOwner()).isNotNull();
        Assertions.assertThat((Object)hd.getOwner()).isInstanceOf(MaleHumanDomain.class);
        Assertions.assertThat((String)hd.getOwner().getName()).isEqualTo((Object)"the owner");
        Assertions.assertThat((int)((MaleHumanDomain)hd.getOwner()).getWeeklyPubVisits()).isEqualTo(4);
        ((IterableAssert)Assertions.assertThat(hd.getInhabitants()).hasSize(2)).extracting("name").contains(new Object[]{"male inhabitant", "female inhabitant"});
    }
}

