/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.Named;
import org.jtransfo.NeedsJTransfo;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListTypeConverter
implements TypeConverter<List, List>,
Named,
NeedsJTransfo {
    private final Logger log = LoggerFactory.getLogger(AbstractListTypeConverter.class);
    private String name;
    private Class<?> toType;
    private JTransfo jTransfo;
    private boolean keepNullList;
    private boolean alwaysNewList;
    private boolean sortList;
    private Supplier<List> emptyListSupplier = ArrayList::new;

    public AbstractListTypeConverter(String name, Class<?> toType) {
        this.name = name;
        this.toType = toType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setJTransfo(JTransfo jTransfo) {
        this.jTransfo = jTransfo;
    }

    protected JTransfo getJTransfo() {
        return this.jTransfo;
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        return false;
    }

    public abstract Object doConvertOne(JTransfo var1, Object var2, Class<?> var3, String ... var4) throws JTransfoException;

    @Override
    public List convert(List toObjects, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
        if (null == toObjects) {
            return this.getNullList();
        }
        List<Object> res = this.newList(domainField, domainObject);
        for (Object to : toObjects) {
            if (null == to) {
                res.add(null);
                continue;
            }
            if (this.isPrimitiveOrString(to.getClass())) {
                res.add(to);
                continue;
            }
            res.add(this.doConvertOne(this.jTransfo, to, this.jTransfo.getDomainClass(to.getClass()), tags));
        }
        return this.sort(res);
    }

    public Object doReverseOne(JTransfo jTransfo, Object domainObject, SyntheticField toField, Class<?> toType, String ... tags) throws JTransfoException {
        return jTransfo.convertTo(domainObject, jTransfo.getToSubType(toType, domainObject), tags);
    }

    @Override
    public List reverse(List domainObjects, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
        if (null == domainObjects) {
            return this.getNullList();
        }
        List<Object> res = this.newList(toField, toObject);
        for (Object domain : domainObjects) {
            if (this.isPrimitiveOrString(domain.getClass())) {
                res.add(domain);
                continue;
            }
            res.add(this.doReverseOne(this.jTransfo, domain, toField, this.toType, tags));
        }
        return this.sort(res);
    }

    private List<Object> newList(SyntheticField targetField, Object targetObject) {
        List res = null;
        if (!this.alwaysNewList && null != targetObject) {
            try {
                res = (List)targetField.get(targetObject);
            }
            catch (Exception exception) {
                this.log.error("Cannot get field " + targetField.getName() + " from " + targetObject, (Throwable)exception);
                res = null;
            }
        }
        if (null != res) {
            res.clear();
        } else {
            res = this.emptyListSupplier.get();
        }
        return this.sort(res);
    }

    private List<Object> sort(List<Object> list) {
        if (this.sortList && null != list && list.size() > 1 && list.get(0) instanceof Comparable) {
            Collections.sort(list);
        }
        return list;
    }

    private List getNullList() {
        return this.keepNullList ? null : this.emptyListSupplier.get();
    }

    public void setKeepNullList(boolean keepNullList) {
        this.keepNullList = keepNullList;
    }

    public void setAlwaysNewList(boolean alwaysNewList) {
        this.alwaysNewList = alwaysNewList;
    }

    public void setSortList(boolean sortList) {
        this.sortList = sortList;
    }

    public void setEmptyListSupplier(Supplier<List> emptyListSupplier) {
        this.emptyListSupplier = emptyListSupplier;
    }

    protected boolean isPrimitiveOrString(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(String.class);
    }
}

