/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.Named;
import org.jtransfo.NeedsJTransfo;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSetTypeConverter
implements TypeConverter<Set, Set>,
Named,
NeedsJTransfo {
    private final Logger log = LoggerFactory.getLogger(AbstractSetTypeConverter.class);
    private String name;
    private Class<?> toType;
    private JTransfo jTransfo;
    private boolean keepNullSet;
    private boolean alwaysNewSet;
    private Supplier<Set> emptySetSupplier = HashSet::new;

    public AbstractSetTypeConverter(String name, Class<?> toType) {
        this.name = name;
        this.toType = toType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setJTransfo(JTransfo jTransfo) {
        this.jTransfo = jTransfo;
    }

    protected JTransfo getJTransfo() {
        return this.jTransfo;
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        return false;
    }

    public abstract Object doConvertOne(JTransfo var1, Object var2, Class<?> var3, String ... var4) throws JTransfoException;

    @Override
    public Set convert(Set toObjects, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
        if (null == toObjects) {
            return this.getNullSet();
        }
        Set<Object> res = this.newSet(domainField, domainObject);
        for (Object to : toObjects) {
            if (null == to) {
                res.add(null);
                continue;
            }
            if (this.isPrimitiveOrString(to.getClass())) {
                res.add(to);
                continue;
            }
            res.add(this.doConvertOne(this.jTransfo, to, this.jTransfo.getDomainClass(to.getClass()), tags));
        }
        return res;
    }

    public Object doReverseOne(JTransfo jTransfo, Object domainObject, SyntheticField toField, Class<?> toType, String ... tags) throws JTransfoException {
        return jTransfo.convertTo(domainObject, jTransfo.getToSubType(toType, domainObject), tags);
    }

    @Override
    public Set reverse(Set domainObjects, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
        if (null == domainObjects) {
            return this.getNullSet();
        }
        Set<Object> res = this.newSet(toField, toObject);
        for (Object domain : domainObjects) {
            if (this.isPrimitiveOrString(domain.getClass())) {
                res.add(domain);
                continue;
            }
            res.add(this.doReverseOne(this.jTransfo, domain, toField, this.toType, tags));
        }
        return res;
    }

    private Set<Object> newSet(SyntheticField targetField, Object targetObject) {
        Set res = null;
        if (!this.alwaysNewSet && null != targetObject) {
            try {
                res = (Set)targetField.get(targetObject);
            }
            catch (Exception exception) {
                this.log.error("Cannot get field " + targetField.getName() + " from " + targetObject, (Throwable)exception);
                res = null;
            }
        }
        if (null != res) {
            res.clear();
        } else {
            res = this.emptySetSupplier.get();
        }
        return res;
    }

    private Set getNullSet() {
        return this.keepNullSet ? null : this.emptySetSupplier.get();
    }

    public void setKeepNullSet(boolean keepNullSet) {
        this.keepNullSet = keepNullSet;
    }

    public void setAlwaysNewSet(boolean alwaysNewSet) {
        this.alwaysNewSet = alwaysNewSet;
    }

    public void setEmptySetSupplier(Supplier<Set> emptySetSupplier) {
        this.emptySetSupplier = emptySetSupplier;
    }

    protected boolean isPrimitiveOrString(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(String.class);
    }
}

