/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.jtransfo.JTransfoException;

public class LockableList<T>
extends ArrayList<T> {
    private static final String READ_ONLY = "Collection is read-only.";
    private boolean readOnly;

    public void lock() {
        this.readOnly = true;
    }

    @Override
    public T set(int i, T t) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return super.set(i, t);
    }

    @Override
    public boolean add(T t) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return super.add(t);
    }

    @Override
    public void add(int i, T t) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        super.add(i, t);
    }

    @Override
    public T remove(int i) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return (T)super.remove(i);
    }

    @Override
    public boolean remove(Object o) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return super.remove(o);
    }

    @Override
    public void clear() {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return super.addAll(ts);
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> ts) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        return super.addAll(i, ts);
    }

    @Override
    protected void removeRange(int i, int i1) {
        if (this.readOnly) {
            throw new JTransfoException(READ_ONLY);
        }
        super.removeRange(i, i1);
    }
}

