/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.Type;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.Named;
import org.jtransfo.ObjectFinder;
import org.jtransfo.StringEnumTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.object.Gender;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.TaggedPersonTo;
import org.junit.Before;
import org.junit.Test;

public class ConvertWithTagsTest {
    private static final String NAME = "ikke";
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        ConfigurableJTransfo impl = JTransfoFactory.get();
        this.jTransfo = impl;
        AddressDomain[] addresses = new AddressDomain[10];
        for (int i = 0; i < 10; ++i) {
            AddressDomain ad = new AddressDomain();
            ad.setId(Long.valueOf(i));
            ad.setAddress("Address " + i);
            addresses[i] = ad;
        }
        impl.getTypeConverters().add(new StringEnumTypeConverter(Gender.class));
        impl.getTypeConverters().add(new Always2TypeConverter(addresses));
        impl.updateTypeConverters();
        impl.getObjectFinders().add(new AddressFinder(addresses));
        impl.updateObjectFinders();
    }

    @Test
    public void testConverterToDomain() throws Exception {
        TaggedPersonTo to = new TaggedPersonTo();
        to.setGender("MALE");
        to.setLastChanged(new Date());
        to.setName(NAME);
        to.setAddress(new AddressTo(3L));
        PersonDomain domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"create"});
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Object)((Object)domain.getGender())).isEqualTo((Object)Gender.MALE);
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"update"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isNull();
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(2L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 2");
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"addressPolice"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isNull();
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"update", "addressPolice"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isNull();
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"addressPolice", "update"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isNull();
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(2L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 2");
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[]{"zzz"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isNull();
        Assertions.assertThat((Object)domain.getAddress()).isNull();
        Assertions.assertThat((Date)domain.getLastChanged()).isNull();
    }

    @Test
    public void testWithFinderAndConverterToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        domain.setGender(Gender.MALE);
        Date now = new Date();
        domain.setLastChanged(now);
        AddressDomain address = new AddressDomain();
        address.setId(7L);
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        TaggedPersonTo to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"create"});
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
        to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"update"});
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(2L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
        to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"addressPolice"});
        Assertions.assertThat((String)to.getName()).isNull();
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
        to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"update", "addressPolice"});
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
        to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"addressPolice", "update"});
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(2L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
        to = (TaggedPersonTo)this.jTransfo.convert((Object)domain, (Object)new TaggedPersonTo(), new String[]{"zzz"});
        Assertions.assertThat((String)to.getName()).isNull();
        Assertions.assertThat((String)to.getGender()).isEqualTo((Object)"MALE");
        Assertions.assertThat((Object)to.getAddress()).isNull();
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
    }

    private class Always2TypeConverter
    implements TypeConverter<AddressTo, AddressDomain>,
    Named {
        private AddressDomain[] addresses;

        public Always2TypeConverter(AddressDomain[] addresses) {
            this.addresses = addresses;
        }

        public String getName() {
            return "always2";
        }

        public boolean canConvert(Type realToType, Type realDomainType) {
            return false;
        }

        public AddressDomain convert(AddressTo object, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
            return this.addresses[2];
        }

        public AddressTo reverse(AddressDomain object, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
            return new AddressTo(2L);
        }
    }

    private class AddressFinder
    implements ObjectFinder {
        private AddressDomain[] addresses;

        public AddressFinder(AddressDomain[] addresses) {
            this.addresses = addresses;
        }

        public <T> T getObject(Class<T> domainClass, Object to, String ... tags) {
            if (domainClass.isAssignableFrom(AddressDomain.class) && to instanceof AddressTo) {
                return (T)this.addresses[((AddressTo)to).getId().intValue()];
            }
            return null;
        }
    }
}

