/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.ListTypeConverter;
import org.jtransfo.object.AbstractHumanDomain;
import org.jtransfo.object.AbstractHumanTo;
import org.jtransfo.object.FemaleHumanDomain;
import org.jtransfo.object.FemaleHumanTo;
import org.jtransfo.object.GroupDomain;
import org.jtransfo.object.GroupTo;
import org.jtransfo.object.MaleHumanDomain;
import org.jtransfo.object.MaleHumanTo;
import org.junit.Before;
import org.junit.Test;

public class InheritedAbstractBaseClassTest {
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        ConfigurableJTransfo jTransfoImpl = JTransfoFactory.get();
        this.jTransfo = jTransfoImpl;
        ListTypeConverter ltc = new ListTypeConverter("abstractHumanToList", AbstractHumanTo.class);
        jTransfoImpl.getTypeConverters().add(ltc);
        jTransfoImpl.updateTypeConverters();
    }

    @Test
    public void testConvertDomainObject() throws Exception {
        GroupDomain gd = new GroupDomain();
        FemaleHumanDomain ld = new FemaleHumanDomain();
        ld.setName("leader");
        ld.setHairColourCount(3);
        MaleHumanDomain sd1 = new MaleHumanDomain();
        sd1.setName("male slave");
        sd1.setWeeklyPubVisits(0);
        FemaleHumanDomain sd2 = new FemaleHumanDomain();
        sd2.setName("female slave");
        sd2.setHairColourCount(1);
        ArrayList<AbstractHumanDomain> slaves = new ArrayList<AbstractHumanDomain>();
        slaves.add(sd1);
        slaves.add(sd2);
        gd.setLeader(ld);
        gd.setSlaves(slaves);
        GroupTo gt = (GroupTo)this.jTransfo.convert((Object)gd, (Object)new GroupTo(), new String[0]);
        Assertions.assertThat((Object)gt.getLeader()).isNotNull();
        Assertions.assertThat((String)gt.getLeader().getName()).isEqualTo((Object)"leader");
        Assertions.assertThat((Object)gt.getLeader()).isInstanceOf(FemaleHumanTo.class);
        Assertions.assertThat((int)((FemaleHumanTo)gt.getLeader()).getHairColourCount()).isEqualTo(3);
        ((ListAssert)Assertions.assertThat(gt.getSlaves()).hasSize(2)).extracting("name").contains(new Object[]{"male slave", "female slave"});
        Assertions.assertThat((Object)gt.getSlaves().get(0)).isInstanceOf(MaleHumanTo.class);
        Assertions.assertThat((int)((MaleHumanTo)gt.getSlaves().get(0)).getWeeklyPubVisits()).isEqualTo(0);
        Assertions.assertThat((Object)gt.getSlaves().get(1)).isInstanceOf(FemaleHumanTo.class);
        Assertions.assertThat((int)((FemaleHumanTo)gt.getSlaves().get(1)).getHairColourCount()).isEqualTo(1);
    }

    @Test
    public void testConvertTransferObject() throws Exception {
        GroupTo gt = new GroupTo();
        FemaleHumanTo lt = new FemaleHumanTo();
        lt.setName("leader");
        lt.setHairColourCount(3);
        MaleHumanTo st1 = new MaleHumanTo();
        st1.setName("male slave");
        st1.setWeeklyPubVisits(0);
        FemaleHumanTo st2 = new FemaleHumanTo();
        st2.setName("female slave");
        st2.setHairColourCount(1);
        ArrayList<AbstractHumanTo> slaves = new ArrayList<AbstractHumanTo>();
        slaves.add(st1);
        slaves.add(st2);
        gt.setLeader(lt);
        gt.setSlaves(slaves);
        GroupDomain gd = (GroupDomain)this.jTransfo.convert((Object)gt, (Object)new GroupDomain(), new String[0]);
        Assertions.assertThat((Object)gd.getLeader()).isNotNull();
        Assertions.assertThat((String)gd.getLeader().getName()).isEqualTo((Object)"leader");
        Assertions.assertThat((Object)gd.getLeader()).isInstanceOf(FemaleHumanDomain.class);
        Assertions.assertThat((int)((FemaleHumanDomain)gd.getLeader()).getHairColourCount()).isEqualTo(3);
        ((ListAssert)Assertions.assertThat(gd.getSlaves()).hasSize(2)).extracting("name").contains(new Object[]{"male slave", "female slave"});
        Assertions.assertThat((Object)gd.getSlaves().get(0)).isInstanceOf(MaleHumanDomain.class);
        Assertions.assertThat((int)((MaleHumanDomain)gd.getSlaves().get(0)).getWeeklyPubVisits()).isEqualTo(0);
        Assertions.assertThat((Object)gd.getSlaves().get(1)).isInstanceOf(FemaleHumanDomain.class);
        Assertions.assertThat((int)((FemaleHumanDomain)gd.getSlaves().get(1)).getHairColourCount()).isEqualTo(1);
    }
}

