/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.jtransfo.AutomaticListTypeConverter;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.TypeConverter;
import org.jtransfo.object.HouseDomain;
import org.jtransfo.object.HouseTo;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveListTypeConverterTest {
    private ConfigurableJTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        this.jTransfo = JTransfoFactory.get();
        AutomaticListTypeConverter listConverter = new AutomaticListTypeConverter((JTransfo)this.jTransfo);
        listConverter.setEmptyListSupplier(() -> new MyArrayList());
        this.jTransfo.with((TypeConverter)listConverter);
    }

    @Test
    public void testConvertDomainObject() throws Exception {
        HouseDomain hd = new HouseDomain();
        hd.setPetNames(Arrays.asList("Garfield", "Odie"));
        HouseTo ht = (HouseTo)this.jTransfo.convert((Object)hd, (Object)new HouseTo(), new String[0]);
        Assertions.assertThat(ht.getPetNames()).containsExactly((Object[])new String[]{"Garfield", "Odie"});
        Assertions.assertThat(hd.getPetNames()).isNotInstanceOf(MyArrayList.class);
        Assertions.assertThat(ht.getPetNames()).isInstanceOf(MyArrayList.class);
    }

    @Test
    public void testConvertTransferObject() throws Exception {
        HouseTo ht = new HouseTo();
        ht.setPetNames(Arrays.asList("Garfield", "Odie"));
        HouseDomain hd = (HouseDomain)this.jTransfo.convert((Object)ht, (Object)new HouseDomain(), new String[0]);
        Assertions.assertThat(hd.getPetNames()).containsExactly((Object[])new String[]{"Garfield", "Odie"});
        Assertions.assertThat(ht.getPetNames()).isNotInstanceOf(MyArrayList.class);
        Assertions.assertThat(hd.getPetNames()).isInstanceOf(MyArrayList.class);
    }

    private class MyArrayList
    extends ArrayList<String> {
        private MyArrayList() {
        }
    }
}

