/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.Arrays;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.jtransfo.AutomaticSetTypeConverter;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.TypeConverter;
import org.jtransfo.object.FlatDomain;
import org.jtransfo.object.FlatTo;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveSetTypeConverterTest {
    private ConfigurableJTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        this.jTransfo = JTransfoFactory.get();
        AutomaticSetTypeConverter setTypeConverter = new AutomaticSetTypeConverter();
        setTypeConverter.setEmptySetSupplier(() -> new MyHashSet());
        this.jTransfo.with((TypeConverter)setTypeConverter);
    }

    @Test
    public void testConvertDomainObject() throws Exception {
        FlatDomain hd = new FlatDomain();
        HashSet<String> pets = new HashSet<String>();
        pets.addAll(Arrays.asList("Garfield", "Odie"));
        hd.setPetNames(pets);
        FlatTo ht = (FlatTo)this.jTransfo.convert((Object)hd, (Object)new FlatTo(), new String[0]);
        Assertions.assertThat(ht.getPetNames()).containsExactly((Object[])new String[]{"Garfield", "Odie"});
        Assertions.assertThat(hd.getPetNames()).isNotInstanceOf(MyHashSet.class);
        Assertions.assertThat(ht.getPetNames()).isInstanceOf(MyHashSet.class);
    }

    @Test
    public void testConvertTransferObject() throws Exception {
        FlatTo ht = new FlatTo();
        HashSet<String> pets = new HashSet<String>();
        pets.addAll(Arrays.asList("Garfield", "Odie"));
        ht.setPetNames(pets);
        FlatDomain hd = (FlatDomain)this.jTransfo.convert((Object)ht, (Object)new FlatDomain(), new String[0]);
        Assertions.assertThat(hd.getPetNames()).containsExactly((Object[])new String[]{"Garfield", "Odie"});
        Assertions.assertThat(ht.getPetNames()).isNotInstanceOf(MyHashSet.class);
        Assertions.assertThat(hd.getPetNames()).isInstanceOf(MyHashSet.class);
    }

    private class MyHashSet
    extends HashSet<String> {
        private MyHashSet() {
        }
    }
}

