/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.assertj.core.api.Assertions;
import org.jtransfo.DomainClass;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.ToHelper;
import org.jtransfo.object.AbstractHumanTo;
import org.jtransfo.object.FemaleHumanDomain;
import org.jtransfo.object.FemaleHumanTo;
import org.jtransfo.object.MaleHumanDomain;
import org.jtransfo.object.MaleHumanTo;
import org.jtransfo.object.NoDomain;
import org.jtransfo.object.PersonTo;
import org.jtransfo.object.SimpleClassDomain;
import org.jtransfo.object.SimpleClassNameTo;
import org.jtransfo.object.SimpleClassTypeTo;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ToHelperTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ToHelper toHelper = new ToHelper();

    @Test
    public void isToTest() throws Exception {
        Assertions.assertThat((boolean)this.toHelper.isTo((Object)new SimpleClassNameTo())).isTrue();
        Assertions.assertThat((boolean)this.toHelper.isTo((Object)new SimpleClassTypeTo())).isTrue();
        Assertions.assertThat((boolean)this.toHelper.isTo((Object)new SimpleClassDomain())).isFalse();
    }

    @Test
    public void testGetDomainClass() throws Exception {
        Assertions.assertThat((Class)this.toHelper.getDomainClass(SimpleClassNameTo.class)).isEqualTo(SimpleClassDomain.class);
        Assertions.assertThat((Class)this.toHelper.getDomainClass(SimpleClassTypeTo.class)).isEqualTo(SimpleClassDomain.class);
    }

    @Test
    public void testGetNoDomainClass() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage(" not annotated with DomainClass.");
        Assertions.assertThat((Class)this.toHelper.getDomainClass(NoDomain.class)).isNull();
    }

    @Test
    public void noClassDomainClassAnnotationTest() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage(" DomainClass annotation does not specify class.");
        Assertions.assertThat((Class)this.toHelper.getDomainClass(NoClassTo.class)).isNull();
    }

    @Test
    public void unknownClassDomainClassAnnotationTest() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage(" DomainClass org.jtransfo.UnknownClass not found.");
        Assertions.assertThat((Class)this.toHelper.getDomainClass(UnknownClassTo.class)).isNull();
    }

    @Test
    public void getToSubTypeNoDomainClassDelegates() throws Exception {
        Assertions.assertThat((Class)this.toHelper.getToSubType(PersonTo.class, (Object)new PersonTo())).isEqualTo(PersonTo.class);
    }

    @Test
    public void getToSubTypeWithDomainClassDelegates() throws Exception {
        Assertions.assertThat((Class)this.toHelper.getToSubType(AbstractHumanTo.class, (Object)new FemaleHumanDomain())).isEqualTo(FemaleHumanTo.class);
        Assertions.assertThat((Class)this.toHelper.getToSubType(AbstractHumanTo.class, (Object)new MaleHumanDomain())).isEqualTo(MaleHumanTo.class);
        Assertions.assertThat((Class)this.toHelper.getToSubType(AbstractHumanTo.class, new Object())).isEqualTo(AbstractHumanTo.class);
        Assertions.assertThat((Class)this.toHelper.getToSubType(AbstractHumanTo.class, (Object)new MaleHumanDomain(){})).isEqualTo(MaleHumanTo.class);
    }

    @DomainClass(value="org.jtransfo.UnknownClass")
    private class UnknownClassTo {
        private UnknownClassTo() {
        }
    }

    @DomainClass
    private class NoClassTo {
        private NoClassTo() {
        }
    }
}

