/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.ToToConverter;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleExtendedDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ToToConverterTest {
    private static final String C_VALUE = "c value";
    private ToToConverter toToConverter;
    private ToToConverter toToConverterAccess;
    private ToToConverter toToConverterArgument;
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.reflectionHelper = new ReflectionHelper();
        Field a = SimpleBaseDomain.class.getDeclaredField("a");
        Field b = SimpleExtendedDomain.class.getDeclaredField("b");
        Field c = SimpleExtendedDomain.class.getDeclaredField("c");
        Field i = SimpleExtendedDomain.class.getDeclaredField("i");
        SimpleSyntheticField sc = new SimpleSyntheticField(c);
        this.reflectionHelper.makeAccessible(a);
        this.reflectionHelper.makeAccessible(c);
        this.reflectionHelper.makeAccessible(i);
        this.toToConverter = new ToToConverter((SyntheticField)new SimpleSyntheticField(a), new SyntheticField[]{sc}, (TypeConverter)new NoConversionTypeConverter());
        this.toToConverterAccess = new ToToConverter((SyntheticField)new SimpleSyntheticField(b), new SyntheticField[]{sc}, (TypeConverter)new NoConversionTypeConverter());
        this.toToConverterArgument = new ToToConverter((SyntheticField)new SimpleSyntheticField(i), new SyntheticField[]{sc}, (TypeConverter)new NoConversionTypeConverter());
    }

    @Test
    public void testConvert() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setC(C_VALUE);
        this.toToConverter.convert((Object)sed, (Object)sed, new String[0]);
        Assertions.assertThat((String)sed.getA()).isEqualTo((Object)C_VALUE);
    }

    @Test
    public void testConvertIllegalAccessException() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setC(C_VALUE);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert domain field c to TO field b, field cannot be accessed.");
        this.toToConverterAccess.convert((Object)sed, (Object)sed, new String[0]);
    }

    @Test
    public void testConvertIllegalArgumentException() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setC(C_VALUE);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert domain field c to TO field i, field needs type conversion.");
        this.toToConverterArgument.convert((Object)sed, (Object)sed, new String[0]);
    }
}

