/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jtransfo.AutomaticListTypeConverter;
import org.jtransfo.AutomaticSetTypeConverter;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.ConvertSourceTarget;
import org.jtransfo.Converter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.NeedsJTransfo;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.ObjectFinder;
import org.jtransfo.ObjectReplacer;
import org.jtransfo.ReadOnlyDomainAutomaticTypeConverter;
import org.jtransfo.ToConverter;
import org.jtransfo.ToDomainTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ConvertInterceptorChainPiece;
import org.jtransfo.internal.ConverterHelper;
import org.jtransfo.internal.LockableList;
import org.jtransfo.internal.NewInstanceObjectFinder;
import org.jtransfo.internal.ToHelper;

public class JTransfoImpl
implements JTransfo,
ConfigurableJTransfo,
ConvertSourceTarget {
    private static final String[] DEFAULT_TAGS_WHEN_NO_TAGS = new String[]{"\u00a7#noTags"};
    private ToHelper toHelper = new ToHelper();
    private ConverterHelper converterHelper = new ConverterHelper();
    private Map<Class, ToConverter> converters = new ConcurrentHashMap<Class, ToConverter>();
    private List<ObjectFinder> modifyableObjectFinders = new ArrayList<ObjectFinder>();
    private List<ObjectFinder> internalObjectFinders = new ArrayList<ObjectFinder>();
    private LockableList<ObjectFinder> objectFinders = new LockableList();
    private List<TypeConverter> modifyableTypeConverters = new ArrayList<TypeConverter>();
    private List<TypeConverter> internalTypeConverters = new ArrayList<TypeConverter>();
    private List<ConvertInterceptor> modifyableConvertInterceptors = new ArrayList<ConvertInterceptor>();
    private ConvertSourceTarget convertInterceptorChain;
    private List<ObjectReplacer> modifyableObjectReplacers = new ArrayList<ObjectReplacer>();
    private LockableList<ObjectReplacer> objectReplacers = new LockableList();

    public JTransfoImpl() {
        this.internalObjectFinders.add(new NewInstanceObjectFinder());
        this.updateObjectFinders();
        this.internalTypeConverters.add(new NoConversionTypeConverter());
        this.internalTypeConverters.add(new ToDomainTypeConverter(this));
        ReadOnlyDomainAutomaticTypeConverter readOnlyDomainAutomaticTypeConverter = new ReadOnlyDomainAutomaticTypeConverter();
        readOnlyDomainAutomaticTypeConverter.setSortList(true);
        this.internalTypeConverters.add(readOnlyDomainAutomaticTypeConverter);
        this.internalTypeConverters.add(new AutomaticSetTypeConverter());
        AutomaticListTypeConverter automaticListTypeConverter = new AutomaticListTypeConverter();
        automaticListTypeConverter.setSortList(true);
        this.internalTypeConverters.add(automaticListTypeConverter);
        this.updateTypeConverters();
        this.updateConvertInterceptors();
        this.updateObjectReplacers();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> plugin = cl.loadClass("org.jtransfo.internal.JTransfoJrebelPlugin");
            Method setInstance = plugin.getMethod("setInstance", JTransfoImpl.class);
            Method preInit = plugin.getMethod("preinit", new Class[0]);
            if (null != setInstance && null != preInit) {
                Object instance = plugin.newInstance();
                setInstance.invoke(instance, this);
                preInit.invoke(instance, new Object[0]);
            }
            System.out.println("jRebel reload support for jTransfo loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public List<TypeConverter> getTypeConverters() {
        return this.modifyableTypeConverters;
    }

    @Override
    public void updateTypeConverters() {
        this.updateTypeConverters(null);
    }

    @Override
    public void updateTypeConverters(List<TypeConverter> newConverters) {
        if (null != newConverters) {
            this.modifyableTypeConverters.clear();
            this.modifyableTypeConverters.addAll(newConverters);
        }
        ArrayList<TypeConverter> allConverters = new ArrayList<TypeConverter>();
        allConverters.addAll(this.modifyableTypeConverters);
        allConverters.addAll(this.internalTypeConverters);
        for (TypeConverter tc : allConverters) {
            if (!(tc instanceof NeedsJTransfo)) continue;
            ((NeedsJTransfo)((Object)tc)).setJTransfo(this);
        }
        this.converterHelper.setTypeConvertersInOrder(allConverters);
    }

    @Override
    public List<ObjectFinder> getObjectFinders() {
        return this.modifyableObjectFinders;
    }

    @Override
    public void updateObjectFinders() {
        this.updateObjectFinders(null);
    }

    @Override
    public void updateObjectFinders(List<ObjectFinder> newObjectFinders) {
        if (null != newObjectFinders) {
            this.modifyableObjectFinders.clear();
            this.modifyableObjectFinders.addAll(newObjectFinders);
        }
        LockableList<ObjectFinder> newList = new LockableList<ObjectFinder>();
        newList.addAll((Collection<ObjectFinder>)this.internalObjectFinders);
        newList.addAll((Collection<ObjectFinder>)this.modifyableObjectFinders);
        newList.lock();
        this.objectFinders = newList;
    }

    @Override
    public List<ObjectReplacer> getObjectReplacers() {
        return this.modifyableObjectReplacers;
    }

    @Override
    public void updateObjectReplacers() {
        this.updateObjectReplacers(null);
    }

    @Override
    public void updateObjectReplacers(List<ObjectReplacer> newObjectReplacers) {
        if (null != newObjectReplacers) {
            this.modifyableObjectReplacers.clear();
            this.modifyableObjectReplacers.addAll(newObjectReplacers);
        }
        LockableList<ObjectReplacer> newList = new LockableList<ObjectReplacer>();
        newList.addAll((Collection<ObjectReplacer>)this.modifyableObjectReplacers);
        newList.lock();
        this.objectReplacers = newList;
    }

    @Override
    public List<ConvertInterceptor> getConvertInterceptors() {
        return this.modifyableConvertInterceptors;
    }

    @Override
    public void updateConvertInterceptors() {
        this.updateConvertInterceptors(null);
    }

    @Override
    public void updateConvertInterceptors(List<ConvertInterceptor> newConvertInterceptors) {
        if (null != newConvertInterceptors) {
            this.modifyableConvertInterceptors.clear();
            this.modifyableConvertInterceptors.addAll(newConvertInterceptors);
        }
        ConvertSourceTarget chainPart = this;
        for (int i = this.modifyableConvertInterceptors.size() - 1; i >= 0; --i) {
            chainPart = new ConvertInterceptorChainPiece(this.modifyableConvertInterceptors.get(i), chainPart);
        }
        this.convertInterceptorChain = chainPart;
    }

    @Override
    public <T> T convert(Object source, T target, String ... tags) {
        if (null == source || null == target) {
            throw new JTransfoException("Source and target are required to be not-null.");
        }
        source = this.replaceObject(source);
        boolean targetIsTo = false;
        if (!this.toHelper.isTo(source)) {
            targetIsTo = true;
            if (!this.toHelper.isTo(target)) {
                throw new JTransfoException(String.format("Neither source nor target are annotated with DomainClass on classes %s and %s.", source.getClass().getName(), target.getClass().getName()));
            }
        }
        if (0 == tags.length) {
            tags = DEFAULT_TAGS_WHEN_NO_TAGS;
        }
        return this.convertInterceptorChain.convert(source, target, targetIsTo, tags);
    }

    @Override
    public <T> T convert(Object source, T target, boolean targetIsTo, String ... tags) {
        source = this.replaceObject(source);
        List<Converter> converters = targetIsTo ? this.getToToConverters(target.getClass()) : this.getToDomainConverters(source.getClass());
        for (Converter converter : converters) {
            converter.convert(source, target, tags);
        }
        return target;
    }

    @Override
    public Object convert(Object source) {
        if (null == source) {
            return null;
        }
        source = this.replaceObject(source);
        Class<?> domainClass = this.getDomainClass(source.getClass());
        return this.convertTo(source, domainClass, new String[0]);
    }

    @Override
    public <T> T convertTo(Object source, Class<T> targetClass, String ... tags) {
        Class<Object> realTarget = targetClass;
        if (null == source) {
            return null;
        }
        source = this.replaceObject(source);
        if (this.isToClass(targetClass)) {
            realTarget = this.getToSubType(targetClass, source);
        }
        return this.convert(source, this.findTarget(source, realTarget, tags), tags);
    }

    @Override
    public <T> List<T> convertList(List<?> source, Class<T> targetClass, String ... tags) {
        if (null == source) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object object : source) {
            result.add(this.convertTo(object, targetClass, tags));
        }
        return result;
    }

    @Override
    public <T> T findTarget(Object source, Class<T> targetClass, String ... tags) {
        if (null == source) {
            return null;
        }
        source = this.replaceObject(source);
        int i = this.objectFinders.size() - 1;
        T target = null;
        while (null == target && i >= 0) {
            target = ((ObjectFinder)this.objectFinders.get(i--)).getObject(targetClass, source, tags);
        }
        if (null == target) {
            throw new JTransfoException("Cannot create instance of target class " + targetClass.getName() + " for source object " + source + ".");
        }
        return target;
    }

    @Override
    public Class<?> getDomainClass(Class<?> toClass) {
        return this.toHelper.getDomainClass(toClass);
    }

    @Override
    public boolean isToClass(Class<?> toClass) {
        return this.toHelper.isToClass(toClass);
    }

    @Override
    public Class<?> getToSubType(Class<?> toType, Object domainObject) {
        return this.toHelper.getToSubType(toType, this.replaceObject(domainObject));
    }

    public void clearCaches() {
        this.converters.clear();
    }

    private List<Converter> getToToConverters(Class toClass) {
        return this.getToConverter(toClass).getToTo();
    }

    private List<Converter> getToDomainConverters(Class toClass) {
        return this.getToConverter(toClass).getToDomain();
    }

    private ToConverter getToConverter(Class toClass) {
        ToConverter toConverter = this.converters.get(toClass);
        if (null == toConverter) {
            Class<?> domainClass = this.getDomainClass(toClass);
            toConverter = this.converterHelper.getToConverter(toClass, domainClass);
            this.converters.put(toClass, toConverter);
        }
        return toConverter;
    }

    private Object replaceObject(Object object) {
        Object res = object;
        for (ObjectReplacer replacer : this.objectReplacers) {
            res = replacer.replaceObject(res);
        }
        return res;
    }
}

