/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jtransfo.AbstractListTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AbstractListTypeConverterTest {
    private static final String NAME = "cname";
    AbstractListTypeConverter listTypeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private SyntheticField field;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.listTypeConverter = new TestListTypeConverter(NAME, AddressTo.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        this.listTypeConverter.setJTransfo(this.jTransfo);
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.listTypeConverter.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.listTypeConverter.canConvert(List.class, List.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(2L);
        AddressTo to2 = new AddressTo();
        to2.setId(1L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        List resList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.field.get(domainObject)).thenReturn((Object)resList);
        List res = this.listTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(2L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(1L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
        ((List)Mockito.verify((Object)resList)).clear();
    }

    @Test
    public void testConvertGetFails() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(2L);
        AddressTo to2 = new AddressTo();
        to2.setId(1L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        List resList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.field.get(domainObject)).thenThrow(new Throwable[]{new NullPointerException()});
        List res = this.listTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(2L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(1L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
    }

    @Test
    public void testConvertSortedNotComparable() throws Exception {
        this.listTypeConverter.setSortList(true);
        AddressTo to1 = new AddressTo();
        to1.setId(2L);
        AddressTo to2 = new AddressTo();
        to2.setId(1L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        List res = this.listTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(2L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(1L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
    }

    @Test
    public void testConvertSortedComparable() throws Exception {
        this.listTypeConverter.setSortList(true);
        AddressTo to1 = new AddressTo();
        to1.setId(12L);
        AddressTo to2 = new AddressTo();
        to2.setId(11L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        List res = this.listTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(11L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(12L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(domainObject);
    }

    @Test
    public void testConvertNewList() throws Exception {
        this.listTypeConverter.setAlwaysNewList(true);
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Object domainObject = new Object();
        List res = this.listTypeConverter.convert(addresses, this.field, domainObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(1L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(2L);
        ((SyntheticField)Mockito.verify((Object)this.field, (VerificationMode)Mockito.times((int)0))).get(domainObject);
        res = this.listTypeConverter.convert(addresses, this.field, null, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressDomain)res.get(0)).getId()).isEqualTo(1L);
        Assertions.assertThat((Long)((AddressDomain)res.get(1)).getId()).isEqualTo(2L);
        ((SyntheticField)Mockito.verify((Object)this.field, (VerificationMode)Mockito.times((int)0))).get(domainObject);
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.field, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.field, null, new String[0])).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        List resList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.field.get(toObject)).thenReturn((Object)resList);
        List res = this.listTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
        ((List)Mockito.verify((Object)resList)).clear();
    }

    @Test
    public void testReverseGetFails() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        Mockito.when((Object)this.field.get(toObject)).thenThrow(new Throwable[]{new NullPointerException()});
        List res = this.listTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
    }

    @Test
    public void testReverseSortNotComparable() throws Exception {
        this.listTypeConverter.setSortList(true);
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(2L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(1L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        List resList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.field.get(toObject)).thenReturn((Object)resList);
        Mockito.when((Object)this.jTransfo.convertTo((Object)ad1, AddressTo.class, new String[0])).thenReturn((Object)new AddressTo(2L));
        Mockito.when((Object)this.jTransfo.convertTo((Object)ad2, AddressTo.class, new String[0])).thenReturn((Object)new AddressTo(1L));
        List res = this.listTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressTo)res.get(0)).getId()).isEqualTo(2L);
        Assertions.assertThat((Long)((AddressTo)res.get(1)).getId()).isEqualTo(1L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
        ((List)Mockito.verify((Object)resList)).clear();
    }

    @Test
    public void testReverseSortComparable() throws Exception {
        this.listTypeConverter.setSortList(true);
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(2L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(1L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Object toObject = new Object();
        List resList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.field.get(toObject)).thenReturn((Object)resList);
        Mockito.when((Object)this.jTransfo.convertTo((Object)ad1, AddressTo.class, new String[0])).thenReturn((Object)new ComparableAddressTo(2L));
        Mockito.when((Object)this.jTransfo.convertTo((Object)ad2, AddressTo.class, new String[0])).thenReturn((Object)new ComparableAddressTo(1L));
        List res = this.listTypeConverter.reverse(addresses, this.field, toObject, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        Assertions.assertThat((Long)((AddressTo)res.get(0)).getId()).isEqualTo(1L);
        Assertions.assertThat((Long)((AddressTo)res.get(1)).getId()).isEqualTo(2L);
        ((SyntheticField)Mockito.verify((Object)this.field)).get(toObject);
        ((List)Mockito.verify((Object)resList)).clear();
    }

    @Test
    public void testReverseNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.field, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.field, null, new String[0])).isNull();
    }

    private class ComparableAddressTo
    extends AddressTo
    implements Comparable<ComparableAddressTo> {
        private ComparableAddressTo(Long id) {
            super(id);
        }

        @Override
        public int compareTo(ComparableAddressTo comparableAddressTo) {
            return (int)(this.getId() - comparableAddressTo.getId());
        }
    }

    private class ComparableAddressDomain
    extends AddressDomain
    implements Comparable<ComparableAddressDomain> {
        private ComparableAddressDomain() {
        }

        @Override
        public int compareTo(ComparableAddressDomain comparableAddressDomain) {
            return (int)(this.getId() - comparableAddressDomain.getId());
        }
    }

    private class TestListTypeConverter
    extends AbstractListTypeConverter {
        private TestListTypeConverter(String name, Class<?> toType) {
            super(name, toType);
        }

        public Object doConvertOne(JTransfo jTransfo, Object toObject, Class<?> domainObjectType, String ... tags) throws JTransfoException {
            if (toObject instanceof AddressTo) {
                long id = ((AddressTo)toObject).getId();
                AddressDomain address = id > 10L ? new ComparableAddressDomain() : new AddressDomain();
                address.setId(id);
                return address;
            }
            return null;
        }
    }
}

