/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.jtransfo.DomainClass;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IllegalArgumentExceptionTest {
    private JTransfo jTransfo;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.jTransfo = JTransfoFactory.get();
    }

    @Test
    public void TestIllegalArgumentException_framework() {
        IaeValueTo to = new IaeValueTo();
        to.setValue("123");
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert TO field value to domain field value,");
        this.jTransfo.convert((Object)to);
    }

    @Test
    public void TestIllegalArgumentException_user() {
        IaeSmallValueTo to = new IaeSmallValueTo();
        to.setSmallValue(2);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert TO field smallValue to domain field smallValue, field cannot be accessed.");
        this.jTransfo.convert((Object)to);
    }

    @DomainClass(domainClass=IaeDomain.class)
    private static class IaeSmallValueTo {
        private int smallValue;

        private IaeSmallValueTo() {
        }

        public int getSmallValue() {
            return this.smallValue;
        }

        public void setSmallValue(int value) {
            this.smallValue = value;
        }
    }

    @DomainClass(domainClass=IaeDomain.class)
    private static class IaeValueTo {
        private String value;

        private IaeValueTo() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class IaeDomain {
        private int value;
        private int smallValue;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getSmallValue() {
            return this.smallValue;
        }

        public void setSmallValue(int value) {
            if (value > 1) {
                throw new IllegalArgumentException("Value should be small!");
            }
            this.smallValue = value;
        }
    }
}

