/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.jtransfo.AutomaticListTypeConverter;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.TypeConverter;
import org.jtransfo.object.AbstractHumanDomain;
import org.jtransfo.object.AbstractHumanTo;
import org.jtransfo.object.FemaleHumanDomain;
import org.jtransfo.object.HouseDomain;
import org.jtransfo.object.HouseTo;
import org.jtransfo.object.MaleHumanDomain;
import org.junit.jupiter.api.Test;

public class WithTypeConverterOrderTest {
    @Test
    public void testHasListConverterCanOverride() {
        ConfigurableJTransfo jTransfo = JTransfoFactory.get();
        HouseDomain houseDomain = this.setupHouseDomain();
        HouseTo htSortedInhabitants = (HouseTo)jTransfo.convert((Object)houseDomain, (Object)new HouseTo(), new String[0]);
        Assertions.assertThat(htSortedInhabitants.getInhabitants()).isNotEmpty();
        ArrayList<AbstractHumanTo> copySorted = new ArrayList<AbstractHumanTo>(htSortedInhabitants.getInhabitants());
        Collections.sort(copySorted);
        Assertions.assertThat(htSortedInhabitants.getInhabitants()).isEqualTo(copySorted);
        jTransfo.with((TypeConverter)new AutomaticListTypeConverter());
        HouseTo htUnsortedInhabitants = (HouseTo)jTransfo.convert((Object)houseDomain, (Object)new HouseTo(), new String[0]);
        Assertions.assertThat(htUnsortedInhabitants.getInhabitants()).isNotEmpty();
        Assertions.assertThat(htUnsortedInhabitants.getInhabitants()).isNotEqualTo(copySorted);
    }

    private HouseDomain setupHouseDomain() {
        HouseDomain hd = new HouseDomain();
        MaleHumanDomain owner = new MaleHumanDomain();
        owner.setName("the owner");
        owner.setWeeklyPubVisits(4);
        MaleHumanDomain id1 = new MaleHumanDomain();
        id1.setName("male inhabitant");
        id1.setWeeklyPubVisits(0);
        FemaleHumanDomain id2 = new FemaleHumanDomain();
        id2.setName("female inhabitant");
        id2.setHairColourCount(1);
        ArrayList<AbstractHumanDomain> inhabitants = new ArrayList<AbstractHumanDomain>();
        inhabitants.add(id1);
        inhabitants.add(id2);
        hd.setOwner(owner);
        hd.setInhabitants(inhabitants);
        return hd;
    }
}

