/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.jtransfo.JTransfoException;
import org.jtransfo.internal.NewInstanceObjectFinder;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.object.SimpleClassDomain;
import org.jtransfo.object.SimpleClassNameTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

public class NewInstanceObjectFinderTest {
    private NewInstanceObjectFinder newInstanceObjectFinder;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.newInstanceObjectFinder = new NewInstanceObjectFinder();
        ReflectionTestUtils.setField((Object)this.newInstanceObjectFinder, (String)"reflectionHelper", (Object)this.reflectionHelper);
    }

    @Test
    public void testInstantiationException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.newInstanceObjectFinder.getObject(SimpleClassDomain.class, (Object)new SimpleClassNameTo(), new String[0]);
    }

    @Test
    public void testIllegalAccessException() throws Exception {
        Mockito.when((Object)this.reflectionHelper.newInstance(SimpleClassDomain.class)).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance for domain class org.jtransfo.object.SimpleClassDomain.");
        this.newInstanceObjectFinder.getObject(SimpleClassDomain.class, (Object)new SimpleClassNameTo(), new String[0]);
    }
}

