/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.ConvertSourceTarget;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.junit.Before;
import org.junit.Test;

public class JTransfoConvertInterceptorTest {
    private JTransfo jTransfo;

    @Before
    public void setUp() throws Exception {
        ConfigurableJTransfo impl = JTransfoFactory.get();
        this.jTransfo = impl;
        impl.with((ConvertInterceptor)new MyConvertInterceptor("X"));
        impl.with((ConvertInterceptor)new MyConvertInterceptor("z"));
    }

    @Test
    public void testToDomain() throws Exception {
        SimpleExtendedTo to = new SimpleExtendedTo();
        to.setA("aaa");
        to.setString("bb");
        to.setC("cccc");
        to.setI(111);
        to.setJ(22);
        to.setK(3333);
        SimpleExtendedDomain res = (SimpleExtendedDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((String)res.getA()).isEqualTo((Object)"aaazX");
        Assertions.assertThat((String)res.getB()).isEqualTo((Object)"bb");
        Assertions.assertThat((String)res.getC()).isNull();
        Assertions.assertThat((int)res.getI()).isEqualTo(111);
    }

    private class MyConvertInterceptor
    implements ConvertInterceptor {
        private String adder;

        private MyConvertInterceptor(String adder) {
            this.adder = adder;
        }

        public <T> T convert(Object source, T target, boolean isTargetTo, ConvertSourceTarget next, String ... tags) {
            Object res = next.convert(source, target, isTargetTo, tags);
            if (res instanceof SimpleExtendedDomain) {
                SimpleExtendedDomain sed = (SimpleExtendedDomain)res;
                try {
                    sed.setA(sed.getA() + this.adder);
                }
                catch (IOException ioe) {
                    System.out.println("Unexpected " + ioe);
                }
            }
            return (T)res;
        }
    }
}

