/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.ToDomainTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleBaseTo;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ToDomainTypeConverterTest {
    private TypeConverter typeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.typeConverter = new ToDomainTypeConverter(this.jTransfo);
        ReflectionTestUtils.setField((Object)this.typeConverter, (String)"reflectionHelper", (Object)this.reflectionHelper);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleBaseTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleExtendedTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleBaseTo.class)).thenReturn(SimpleBaseDomain.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleExtendedTo.class)).thenReturn(SimpleExtendedDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(SimpleBaseTo.class), Matchers.anyObject())).thenReturn(SimpleBaseTo.class);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.typeConverter.canConvert(String.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleBaseDomain.class)).isTrue();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleExtendedDomain.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleExtendedDomain.class)).isTrue();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleBaseDomain.class)).isTrue();
    }

    @Test
    public void testConvert() throws Exception {
        SimpleBaseTo source = new SimpleBaseTo();
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseDomain.class);
        String[] tags = new String[]{"a", "b", "c"};
        this.typeConverter.convert((Object)source, field, null, tags);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)source, SimpleBaseDomain.class, tags);
    }

    @Test
    public void testConvertNull() throws Exception {
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseDomain.class);
        String[] tags = new String[]{"a", "b", "c"};
        Assertions.assertThat((Object)this.typeConverter.convert(null, field, null, tags)).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        SimpleBaseTo target = new SimpleBaseTo();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenReturn((Object)target);
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseTo.class);
        String[] tags = new String[]{"a", "b", "c"};
        this.typeConverter.reverse((Object)source, field, null, tags);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convert((Object)source, (Object)target, tags);
    }

    @Test
    public void testReverseNullHandling() throws Exception {
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseTo.class);
        Assertions.assertThat((Object)this.typeConverter.reverse(null, field, null, new String[0])).isNull();
    }

    @Test
    public void testReverseInstantiationException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        SimpleBaseTo target = new SimpleBaseTo();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new InstantiationException()});
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseTo.class);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, field, null, new String[0]);
    }

    @Test
    public void testReverseIllegalAccessException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        SimpleBaseTo target = new SimpleBaseTo();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalAccessException()});
        SyntheticField field = (SyntheticField)Mockito.mock(SyntheticField.class);
        Mockito.when((Object)field.getType()).thenReturn(SimpleBaseTo.class);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, field, null, new String[0]);
    }
}

