/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.Type;
import java.util.Set;
import org.jtransfo.AbstractSetTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.TypeUtil;
import org.jtransfo.internal.SyntheticField;

public class AutomaticSetTypeConverter
extends AbstractSetTypeConverter {
    private static final String NAME = "automaticSet";

    public AutomaticSetTypeConverter() {
        super(NAME, Object.class);
    }

    public AutomaticSetTypeConverter(String name) {
        super(name, Object.class);
    }

    public AutomaticSetTypeConverter(JTransfo jTransfo) {
        super(NAME, Object.class);
        super.setJTransfo(jTransfo);
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        Class<?> toClass = TypeUtil.getRawClass(realToType);
        Class<?> domainClass = TypeUtil.getRawClass(realDomainType);
        if (!Set.class.isAssignableFrom(toClass) || !Set.class.isAssignableFrom(domainClass)) {
            return false;
        }
        Class<?> paramRealToType = TypeUtil.getFirstTypeArgument(realToType);
        Class<?> paramRealDomainType = TypeUtil.getFirstTypeArgument(realDomainType);
        if (paramRealToType == null || paramRealDomainType == null) {
            return false;
        }
        return this.getJTransfo().isToClass(paramRealToType) && paramRealDomainType.isAssignableFrom(this.getJTransfo().getDomainClass(paramRealToType)) || this.isPrimitiveOrString(paramRealToType) && paramRealDomainType == paramRealToType;
    }

    @Override
    public Object doConvertOne(JTransfo jTransfo, Object toObject, Class<?> domainObjectType, String ... tags) throws JTransfoException {
        return jTransfo.convertTo(toObject, domainObjectType, tags);
    }

    @Override
    public Object doReverseOne(JTransfo jTransfo, Object domainObject, SyntheticField toField, Class<?> toType, String ... tags) throws JTransfoException {
        Class<?> clazz = TypeUtil.getFirstTypeArgument(toField.getGenericType());
        return jTransfo.convertTo(domainObject, jTransfo.getToSubType(clazz, domainObject), tags);
    }
}

