/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SyntheticField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessorSyntheticField
implements SyntheticField {
    private final Logger log = LoggerFactory.getLogger(AccessorSyntheticField.class);
    private static final String GET_SET_ITO = "InvocationTargetException trying to use %s on object of type %s. Expected type is %s. Cause is: %s";
    private String name;
    private Field field;
    private Method getter;
    private Method setter;
    private boolean getUsingFieldLogged;
    private boolean setUsingFieldLogged;

    AccessorSyntheticField(ReflectionHelper reflectionHelper, Class<?> clazz, Field field) {
        this.field = field;
        this.getter = this.findGetter(reflectionHelper, clazz, field.getType(), field.getName());
        this.setter = reflectionHelper.getMethod(clazz, null, this.getSetterName(field.getName()), field.getType());
        this.name = field.getName();
    }

    AccessorSyntheticField(ReflectionHelper reflectionHelper, Class<?> clazz, String name, boolean readOnlyField) throws JTransfoException {
        this.field = null;
        this.getter = this.findGetter(reflectionHelper, clazz, null, name);
        if (null == this.getter) {
            throw new JTransfoException("Cannot find getter from " + this.getGetterNameAlternatives(name) + " on class " + clazz.getName() + ".");
        }
        if (!readOnlyField) {
            Class<?> type = this.getter.getReturnType();
            this.setter = reflectionHelper.getMethod(clazz, null, this.getSetterName(name), type);
            if (null == this.setter) {
                throw new JTransfoException("Cannot find setter " + this.getSetterName(name) + " on class " + clazz.getName() + ".");
            }
        }
        this.name = name;
    }

    private Method findGetter(ReflectionHelper reflectionHelper, Class<?> clazz, Class<?> returnType, String name) {
        for (String tryName : this.getGetterNameAlternatives(name)) {
            Method method = reflectionHelper.getMethod(clazz, null, tryName, new Class[0]);
            if (null == method) continue;
            return method;
        }
        return null;
    }

    @Override
    public Object get(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (null != this.getter) {
            try {
                return this.getter.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException && !(ite.getCause() instanceof JTransfoException)) {
                    throw (RuntimeException)ite.getCause();
                }
                throw new JTransfoException(String.format(GET_SET_ITO, this.getter.getName(), object.getClass().getName(), this.getter.getDeclaringClass().getName(), ite.getCause().getMessage()), ite.getCause());
            }
        }
        if (!this.getUsingFieldLogged) {
            this.log.warn("Cannot find getter (not public, wrong name or wrong type), using field to access field {} of {}.", (Object)this.name, (Object)this.field.getType().getName());
            this.getUsingFieldLogged = true;
        }
        return this.field.get(object);
    }

    @Override
    public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException {
        if (null != this.setter) {
            try {
                this.setter.invoke(object, value);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException && !(ite.getCause() instanceof JTransfoException)) {
                    throw (RuntimeException)ite.getCause();
                }
                throw new JTransfoException(String.format(GET_SET_ITO, this.setter.getName(), object.getClass().getName(), this.setter.getDeclaringClass().getName(), ite.getCause().getMessage()), ite.getCause());
            }
        } else {
            if (!this.setUsingFieldLogged) {
                this.log.warn("Cannot find setter (not public, wrong name or wrong type), using field to access field {} of {}.", (Object)this.name, (Object)this.field.getType().getName());
                this.setUsingFieldLogged = true;
            }
            this.field.set(object, value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        if (null != this.field) {
            return this.field.getType();
        }
        return this.getter.getReturnType();
    }

    @Override
    public Type getGenericType() {
        if (null != this.field) {
            return this.field.getGenericType();
        }
        return this.getter.getGenericReturnType();
    }

    protected List<String> getGetterNameAlternatives(String fieldName) {
        String base = this.capitalize(fieldName);
        ArrayList<String> res = new ArrayList<String>();
        res.add("get" + this.capitalize(fieldName));
        res.add(fieldName);
        String alt = "is" + base;
        if (alt.startsWith("isIs")) {
            res.add("i" + alt.substring(3));
        }
        res.add(alt);
        alt = "has" + base;
        if (!alt.startsWith("hasIs")) {
            if (alt.startsWith("hasHas")) {
                res.add("h" + alt.substring(4));
            } else {
                res.add(alt);
            }
        }
        return res;
    }

    private String getSetterName(String fieldName) {
        return "set" + this.capitalize(fieldName);
    }

    private String capitalize(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

