/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.List;
import org.jtransfo.DomainClass;
import org.jtransfo.DomainClassDelegate;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.ReflectionHelper;

public class ToHelper {
    private ReflectionHelper reflectionHelper = new ReflectionHelper();

    public boolean isTo(Object object) {
        return this.isToClass(object.getClass());
    }

    public boolean isToClass(Class<?> toClass) {
        List<DomainClass> domainClasses = this.reflectionHelper.getAnnotationWithMeta(toClass, DomainClass.class);
        return 0 != domainClasses.size();
    }

    public Class<?> getDomainClass(Class<?> toClass) {
        List<DomainClass> domainClasses = this.reflectionHelper.getAnnotationWithMeta(toClass, DomainClass.class);
        if (0 == domainClasses.size()) {
            throw new JTransfoException("Transfer object of type " + toClass.getName() + " not annotated with DomainClass.");
        }
        if (1 < domainClasses.size()) {
            throw new JTransfoException("Transfer object of type " + toClass.getName() + " DomainClass is ambiguous, check your meta-annotations.");
        }
        DomainClass domainClass = domainClasses.get(0);
        if (DomainClass.DefaultClass.class != domainClass.domainClass()) {
            return domainClass.domainClass();
        }
        if ("?".equals(domainClass.value())) {
            throw new JTransfoException("Transfer object of type " + toClass.getName() + " DomainClass annotation does not specify class.");
        }
        try {
            return this.reflectionHelper.loadClass(domainClass.value());
        }
        catch (ClassNotFoundException cnfe) {
            throw new JTransfoException("Transfer object of type " + toClass.getName() + " DomainClass " + domainClass.value() + " not found.", cnfe);
        }
    }

    public Class<?> getToSubType(Class<?> toType, Object domainObject) {
        DomainClassDelegate domainClassDelegate = toType.getAnnotation(DomainClassDelegate.class);
        if (null != domainClassDelegate) {
            for (Class delegate : domainClassDelegate.delegates()) {
                Class<?> delegateDomain = this.getDomainClass(delegate);
                if (!delegateDomain.isInstance(domainObject)) continue;
                toType = delegate;
            }
        }
        return toType;
    }
}

