/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.ClassReplacer;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.object.PersonTo;
import org.jtransfo.object.PersonWithAgeDomain;
import org.jtransfo.object.PersonWithAgeDomainImpl;
import org.jtransfo.object.PersonWithAgeTo;
import org.junit.Before;
import org.junit.Test;

public class ClassReplacerTest {
    private static final String NAME = "ikke";
    private JTransfo jTransfo;

    @Before
    public void setup() {
        ConfigurableJTransfo impl = JTransfoFactory.get();
        impl.with((ClassReplacer)new StoriedHouseClassReplacer());
        this.jTransfo = impl;
    }

    @Test
    public void testReplaceClassToDomain() {
        PersonWithAgeTo to = new PersonWithAgeTo();
        to.setName("Joske");
        PersonWithAgeDomain res = (PersonWithAgeDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((Object)res).isInstanceOf(PersonWithAgeDomainImpl.class);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske");
        res = (PersonWithAgeDomain)this.jTransfo.convertTo((Object)to, PersonWithAgeDomain.class, new String[0]);
        Assertions.assertThat((Object)res).isInstanceOf(PersonWithAgeDomainImpl.class);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske");
        res = (PersonWithAgeDomain)this.jTransfo.convertTo((Object)to, PersonWithAgeDomainImpl.class, new String[0]);
        Assertions.assertThat((Object)res).isInstanceOf(PersonWithAgeDomainImpl.class);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske");
    }

    @Test
    public void testReplaceClassToTo() {
        PersonWithAgeDomainImpl domain = new PersonWithAgeDomainImpl();
        domain.setName("Joske");
        domain.setAge(18);
        PersonTo res = (PersonTo)this.jTransfo.convertTo((Object)domain, PersonTo.class, new String[0]);
        Assertions.assertThat((Object)res).isInstanceOf(PersonWithAgeTo.class);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske");
        res = (PersonTo)this.jTransfo.convertTo((Object)domain, PersonWithAgeTo.class, new String[0]);
        Assertions.assertThat((Object)res).isInstanceOf(PersonWithAgeTo.class);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske");
    }

    private class StoriedHouseClassReplacer
    implements ClassReplacer {
        private StoriedHouseClassReplacer() {
        }

        public Class replaceClass(Class clazz) {
            if (clazz == PersonWithAgeDomain.class) {
                return PersonWithAgeDomainImpl.class;
            }
            if (clazz == PersonTo.class) {
                return PersonWithAgeTo.class;
            }
            return clazz;
        }
    }
}

