/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.PostConverter;
import org.jtransfo.PreConverter;
import org.jtransfo.StringEnumTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.object.DeleteGenderPostConverter;
import org.jtransfo.object.DoubleNamePostConverter;
import org.jtransfo.object.Gender;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonWithInvalidPostConvertTo;
import org.jtransfo.object.PersonWithInvalidPreConvertTo;
import org.jtransfo.object.PersonWithMultiplePrePostTo;
import org.jtransfo.object.PersonWithPrePostTo;
import org.jtransfo.object.SkipMePreConverter;
import org.jtransfo.object.SkipOtherPreConverter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JTransfoPrePostConverterTest {
    private JTransfo jTransfo;

    @BeforeEach
    public void setUp() throws Exception {
        ConfigurableJTransfo impl = JTransfoFactory.get();
        this.jTransfo = impl;
        impl.with((TypeConverter)new StringEnumTypeConverter(Gender.class));
        impl.with((PreConverter)new SkipMePreConverter());
        impl.with((PreConverter)new SkipOtherPreConverter());
        impl.with((PostConverter)new DeleteGenderPostConverter());
        impl.with((PostConverter)new DoubleNamePostConverter());
    }

    @Test
    public void testToDomain_one() throws Exception {
        PersonWithPrePostTo to = new PersonWithPrePostTo();
        to.setName("Joe");
        to.setGender("MALE");
        PersonDomain res = (PersonDomain)this.jTransfo.convertTo((Object)to, PersonDomain.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joe");
        Assertions.assertThat((Object)((Object)res.getGender())).isNull();
    }

    @Test
    public void testToTo_one() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Joe");
        domain.setGender(Gender.MALE);
        PersonWithPrePostTo res = (PersonWithPrePostTo)this.jTransfo.convertTo((Object)domain, PersonWithPrePostTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joe");
        Assertions.assertThat((String)res.getGender()).isNull();
    }

    @Test
    public void testToDomain_one_skip() throws Exception {
        PersonWithPrePostTo to = new PersonWithPrePostTo();
        to.setName("Me");
        to.setGender("MALE");
        PersonDomain res = (PersonDomain)this.jTransfo.convertTo((Object)to, PersonDomain.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((Object)((Object)res.getGender())).isNull();
    }

    @Test
    public void testToTo_one_skip() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Me");
        domain.setGender(Gender.MALE);
        PersonWithPrePostTo res = (PersonWithPrePostTo)this.jTransfo.convertTo((Object)domain, PersonWithPrePostTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((String)res.getGender()).isNull();
    }

    @Test
    public void testToDomain_multiple() throws Exception {
        PersonWithMultiplePrePostTo to = new PersonWithMultiplePrePostTo();
        to.setName("Joe");
        to.setGender("MALE");
        PersonDomain res = (PersonDomain)this.jTransfo.convertTo((Object)to, PersonDomain.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"JoeJoe");
        Assertions.assertThat((Object)((Object)res.getGender())).isNull();
    }

    @Test
    public void testToTo_multiple() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Joe");
        domain.setGender(Gender.MALE);
        PersonWithMultiplePrePostTo res = (PersonWithMultiplePrePostTo)this.jTransfo.convertTo((Object)domain, PersonWithMultiplePrePostTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"JoeJoe");
        Assertions.assertThat((String)res.getGender()).isNull();
    }

    @Test
    public void testToDomain_multiple_skip1() throws Exception {
        PersonWithMultiplePrePostTo to = new PersonWithMultiplePrePostTo();
        to.setName("Me");
        to.setGender("MALE");
        PersonDomain res = (PersonDomain)this.jTransfo.convertTo((Object)to, PersonDomain.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((Object)((Object)res.getGender())).isNull();
    }

    @Test
    public void testToDomain_multiple_skip2() throws Exception {
        PersonWithMultiplePrePostTo to = new PersonWithMultiplePrePostTo();
        to.setName("Other");
        to.setGender("MALE");
        PersonDomain res = (PersonDomain)this.jTransfo.convertTo((Object)to, PersonDomain.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((Object)((Object)res.getGender())).isNull();
    }

    @Test
    public void testToTo_multiple_skip1() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Me");
        domain.setGender(Gender.MALE);
        PersonWithMultiplePrePostTo res = (PersonWithMultiplePrePostTo)this.jTransfo.convertTo((Object)domain, PersonWithMultiplePrePostTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((String)res.getGender()).isNull();
    }

    @Test
    public void testToTo_multiple_skip2() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Other");
        domain.setGender(Gender.MALE);
        PersonWithMultiplePrePostTo res = (PersonWithMultiplePrePostTo)this.jTransfo.convertTo((Object)domain, PersonWithMultiplePrePostTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isNull();
        Assertions.assertThat((String)res.getGender()).isNull();
    }

    @Test
    public void testinvalidPreConverter() throws Exception {
        JTransfoException exc = (JTransfoException)org.junit.jupiter.api.Assertions.assertThrows(JTransfoException.class, () -> {
            PersonWithInvalidPreConvertTo cfr_ignored_0 = (PersonWithInvalidPreConvertTo)this.jTransfo.convertTo((Object)new PersonDomain(), PersonWithInvalidPreConvertTo.class, new String[0]);
        });
        Assertions.assertThat((String)exc.getMessage()).isEqualTo((Object)"Cannot find preConverter invalid.");
    }

    @Test
    public void testinvalidPostConverter() throws Exception {
        JTransfoException exc = (JTransfoException)org.junit.jupiter.api.Assertions.assertThrows(JTransfoException.class, () -> {
            PersonWithInvalidPostConvertTo cfr_ignored_0 = (PersonWithInvalidPostConvertTo)this.jTransfo.convertTo((Object)new PersonDomain(), PersonWithInvalidPostConvertTo.class, new String[0]);
        });
        Assertions.assertThat((String)exc.getMessage()).isEqualTo((Object)"Cannot find postConverter invalid.");
    }
}

