/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.ObjectFinder;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonRodTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JTransfoReadOnlyDomainTest {
    private static final String BLA = "something";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ConfigurableJTransfo jTransfo;

    @Before
    public void setup() {
        this.jTransfo = JTransfoFactory.get();
        final AddressDomain address = new AddressDomain();
        address.setId(1L);
        ObjectFinder objectFinder = new ObjectFinder(){

            public <T> T getObject(Class<T> domainClass, Object to, String ... tags) throws JTransfoException {
                if (to instanceof AddressTo && 1L == ((AddressTo)to).getId()) {
                    return (T)address;
                }
                return null;
            }
        };
        this.jTransfo.with(objectFinder);
    }

    @Test
    public void testConvertToDomainRodFound() throws Exception {
        PersonRodTo to = new PersonRodTo();
        to.setName("Joske");
        to.setAddress(new AddressTo(1L));
        PersonDomain result = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[0]);
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Joske");
        Assertions.assertThat((Object)result.getAddress()).isNotNull();
        Assertions.assertThat((Long)result.getAddress().getId()).isEqualTo(1L);
    }

    @Test
    public void testConvertToDomainRodNotFound() throws Exception {
        PersonRodTo to = new PersonRodTo();
        to.setName("Joske");
        to.setAddress(new AddressTo(2L));
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of target class org.jtransfo.object.AddressDomain for source object org.jtransfo.object.AddressTo");
        this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[0]);
    }

    @Test
    public void testConvertToDomainRodNull() throws Exception {
        PersonRodTo to = new PersonRodTo();
        to.setName("Joske");
        to.setAddress(null);
        PersonDomain result = (PersonDomain)this.jTransfo.convert((Object)to, (Object)new PersonDomain(), new String[0]);
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Joske");
        Assertions.assertThat((Object)result.getAddress()).isNull();
    }
}

