/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.ReadOnlyDomainAutomaticSetTypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ReadOnlyDomainAutomaticSetTypeConverterTest {
    private static final String NAME = "cname";
    ReadOnlyDomainAutomaticSetTypeConverter setTypeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private SyntheticField setField;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setTypeConverter = new ReadOnlyDomainAutomaticSetTypeConverter(NAME);
        this.setTypeConverter.setJTransfo(this.jTransfo);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        Mockito.when((Object)this.setField.getType()).thenReturn(Set.class);
        Mockito.when((Object)this.setField.getGenericType()).thenReturn((Object)AddressSetContainer.class.getField("addressToSet").getGenericType());
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.setTypeConverter.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.setTypeConverter.canConvert(Set.class, Set.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        HashSet<AddressTo> addresses = new HashSet<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Set res = this.setTypeConverter.convert(addresses, this.setField, null, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(1);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to1, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to2, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((Iterable)this.setTypeConverter.convert(null, this.setField, null, new String[0])).isEmpty();
        this.setTypeConverter.setKeepNullSet(true);
        Assertions.assertThat((Iterable)this.setTypeConverter.convert(null, this.setField, null, new String[0])).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        HashSet<AddressDomain> addresses = new HashSet<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        Set res = this.setTypeConverter.reverse(addresses, this.setField, null, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(1);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
    }

    @Test
    public void testReverseNull() throws Exception {
        Assertions.assertThat((Iterable)this.setTypeConverter.reverse(null, this.setField, null, new String[0])).isEmpty();
        this.setTypeConverter.setKeepNullSet(true);
        Assertions.assertThat((Iterable)this.setTypeConverter.reverse(null, this.setField, null, new String[0])).isNull();
    }

    class AddressSetContainer {
        public Set<AddressTo> addressToSet;

        AddressSetContainer() {
        }
    }
}

