/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.ReadOnlyDomainAutomaticListTypeConverterTest;
import org.jtransfo.ReadOnlyDomainAutomaticSetTypeConverterTest;
import org.jtransfo.ReadOnlyDomainAutomaticTypeConverter;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleBaseTo;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ReadOnlyDomainAutomaticTypeConverterTest {
    private ReadOnlyDomainAutomaticTypeConverter typeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Mock
    private SyntheticField toField;
    @Mock
    private SyntheticField domainField;
    @Mock
    private SyntheticField listField;
    @Mock
    private SyntheticField setField;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.typeConverter = new ReadOnlyDomainAutomaticTypeConverter();
        this.typeConverter.setJTransfo(this.jTransfo);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        Mockito.when((Object)this.listField.getType()).thenReturn(List.class);
        Mockito.when((Object)this.listField.getGenericType()).thenReturn((Object)ReadOnlyDomainAutomaticListTypeConverterTest.AddressListContainer.class.getField("addressToList").getGenericType());
        Mockito.when((Object)this.setField.getType()).thenReturn(Set.class);
        Mockito.when((Object)this.setField.getGenericType()).thenReturn((Object)ReadOnlyDomainAutomaticSetTypeConverterTest.AddressSetContainer.class.getField("addressToSet").getGenericType());
        ReflectionTestUtils.setField((Object)this.typeConverter, (String)"reflectionHelper", (Object)this.reflectionHelper);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleBaseTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleExtendedTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleBaseTo.class)).thenReturn(SimpleBaseDomain.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleExtendedTo.class)).thenReturn(SimpleExtendedDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(SimpleBaseTo.class), Matchers.anyObject())).thenReturn(SimpleBaseTo.class);
        Mockito.when((Object)this.domainField.getType()).thenReturn(SimpleBaseDomain.class);
        Mockito.when((Object)this.toField.getType()).thenReturn(SimpleBaseTo.class);
    }

    @Test
    public void testCanConvertSimple() throws Exception {
        Assertions.assertThat((boolean)this.typeConverter.canConvert(String.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleBaseDomain.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleExtendedDomain.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleExtendedDomain.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleBaseDomain.class)).isFalse();
    }

    @Test
    public void testConvertSimple() throws Exception {
        SimpleBaseTo source = new SimpleBaseTo();
        this.typeConverter.convert((Object)source, this.domainField, null, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)source, SimpleBaseDomain.class, new String[]{"\u00a7#readOnlyDomain"});
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).getDomainClass(SimpleBaseTo.class);
        Assertions.assertThat((Object)this.typeConverter.convert((Object)source, this.domainField, null, new String[0])).isNull();
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((Object)this.typeConverter.convert(null, this.domainField, null, new String[0])).isNull();
    }

    @Test
    public void testReverseSimple() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        SimpleBaseTo target = new SimpleBaseTo();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenReturn((Object)target);
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convert((Object)source, (Object)target, new String[0]);
    }

    @Test
    public void testReverseNullHandling() throws Exception {
        Assertions.assertThat((Object)this.typeConverter.reverse(null, this.toField, null, new String[0])).isNull();
    }

    @Test
    public void testReverseInstantiationException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
    }

    @Test
    public void testReverseIllegalAccessException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
    }

    @Test
    public void testName() throws Exception {
        Assertions.assertThat((String)this.typeConverter.getName()).isEqualTo((Object)"readOnlyDomain");
        this.typeConverter.setName("bla");
        Assertions.assertThat((String)this.typeConverter.getName()).isEqualTo((Object)"bla");
    }

    @Test
    public void testCanConvertList() throws Exception {
        Assertions.assertThat((boolean)this.typeConverter.canConvert(List.class, List.class)).isFalse();
    }

    @Test
    public void testCanConvertSet() throws Exception {
        Assertions.assertThat((boolean)this.typeConverter.canConvert(Set.class, Set.class)).isFalse();
    }

    @Test
    public void testConvertList() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        List res = (List)this.typeConverter.convert(addresses, this.listField, null, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to1, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to2, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
    }

    @Test
    public void testConvertSet() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        HashSet<AddressTo> addresses = new HashSet<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        Set res = (Set)this.typeConverter.convert(addresses, this.setField, null, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(1);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to1, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to2, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
    }

    @Test
    public void testConvertNullList() throws Exception {
        Assertions.assertThat((List)((List)this.typeConverter.convert(null, this.listField, null, new String[0]))).isEmpty();
        this.typeConverter.setKeepNullList(true);
        Assertions.assertThat((Object)this.typeConverter.convert(null, this.listField, null, new String[0])).isNull();
    }

    @Test
    public void testConvertNullSet() throws Exception {
        Assertions.assertThat((Iterable)((Set)this.typeConverter.convert(null, this.setField, null, new String[0]))).isEmpty();
        this.typeConverter.setKeepNullSet(true);
        Assertions.assertThat((Object)this.typeConverter.convert(null, this.setField, null, new String[0])).isNull();
    }

    @Test
    public void testReverseList() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        ArrayList resList = new ArrayList();
        Object to = new Object();
        Mockito.when((Object)this.listField.get(to)).thenReturn(resList);
        List res = (List)this.typeConverter.reverse(addresses, this.listField, to, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        Assertions.assertThat((List)res).isEqualTo(resList);
    }

    @Test
    public void testReverseSet() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        HashSet<AddressDomain> addresses = new HashSet<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        HashSet resList = new HashSet();
        Object to = new Object();
        Mockito.when((Object)this.setField.get(to)).thenReturn(resList);
        Set res = (Set)this.typeConverter.reverse(addresses, this.setField, to, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(1);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        Assertions.assertThat((Iterable)res).isEqualTo(resList);
    }

    @Test
    public void testReverseList_new() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        ArrayList resList = new ArrayList();
        Object to = new Object();
        Mockito.when((Object)this.listField.get(to)).thenReturn(resList);
        this.typeConverter.setAlwaysNewList(true);
        this.typeConverter.setSortList(true);
        List res = (List)this.typeConverter.reverse(addresses, this.listField, to, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        Assertions.assertThat((List)res).isNotEqualTo(resList);
    }

    @Test
    public void testReverseSet_new() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        HashSet<AddressDomain> addresses = new HashSet<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        HashSet resList = new HashSet();
        Object to = new Object();
        Mockito.when((Object)this.setField.get(to)).thenReturn(resList);
        this.typeConverter.setAlwaysNewSet(true);
        Set res = (Set)this.typeConverter.reverse(addresses, this.setField, to, new String[0]);
        Assertions.assertThat((Iterable)res).isNotNull();
        Assertions.assertThat((Iterable)res).hasSize(1);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
        Assertions.assertThat((Iterable)res).isNotEqualTo(resList);
    }

    @Test
    public void testReverseNullList() throws Exception {
        Assertions.assertThat((List)((List)this.typeConverter.reverse(null, this.listField, null, new String[0]))).isEmpty();
        this.typeConverter.setKeepNullList(true);
        Assertions.assertThat((Object)this.typeConverter.reverse(null, this.listField, null, new String[0])).isNull();
    }

    @Test
    public void testReverseNullSet() throws Exception {
        Assertions.assertThat((Iterable)((Set)this.typeConverter.reverse(null, this.setField, null, new String[0]))).isEmpty();
        this.typeConverter.setKeepNullSet(true);
        Assertions.assertThat((Object)this.typeConverter.reverse(null, this.setField, null, new String[0])).isNull();
    }
}

