/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.ReadOnlyDomainListTypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ReadOnlyDomainListTypeConverterTest {
    private static final String NAME = "cname";
    ReadOnlyDomainListTypeConverter listTypeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private SyntheticField listField;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.listTypeConverter = new ReadOnlyDomainListTypeConverter(NAME, AddressTo.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        this.listTypeConverter.setJTransfo(this.jTransfo);
        Mockito.when((Object)this.listField.getType()).thenReturn(List.class);
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.listTypeConverter.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.listTypeConverter.canConvert(List.class, List.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        List res = this.listTypeConverter.convert(addresses, this.listField, null, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to1, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)to2, AddressDomain.class, new String[]{"\u00a7#readOnlyDomain"});
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.listField, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.listField, null, new String[0])).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        List res = this.listTypeConverter.reverse(addresses, this.listField, null, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
    }

    @Test
    public void testReverseNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.listField, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.listField, null, new String[0])).isNull();
    }
}

