/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jtransfo.PreConverter;
import org.jtransfo.internal.CombinedPreConverter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class CombinedPreConverterTest {
    @Spy
    private ResultPreConverter first = new ResultPreConverter(PreConverter.Result.CONTINUE);
    @Spy
    private ResultPreConverter second = new ResultPreConverter(PreConverter.Result.SKIP);
    @Spy
    private ResultPreConverter third = new ResultPreConverter(PreConverter.Result.CONTINUE);
    private List<PreConverter<String, Integer>> preConverters;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.preConverters = Arrays.asList(this.first, this.second, this.third);
    }

    @Test
    public void preConvertToTo() throws Exception {
        CombinedPreConverter combined = new CombinedPreConverter(this.preConverters);
        Assertions.assertThat((Object)combined.preConvertToTo((Object)3, (Object)"zzz", new String[]{"bla"})).isEqualTo((Object)PreConverter.Result.SKIP);
        ((ResultPreConverter)Mockito.verify((Object)this.first)).preConvertToTo(3, "zzz", "bla");
        ((ResultPreConverter)Mockito.verify((Object)this.second)).preConvertToTo(3, "zzz", "bla");
        ((ResultPreConverter)Mockito.verify((Object)this.third, (VerificationMode)Mockito.never())).preConvertToTo(3, "zzz", "bla");
    }

    @Test
    public void preConvertToDomain() throws Exception {
        CombinedPreConverter combined = new CombinedPreConverter(this.preConverters);
        Assertions.assertThat((Object)combined.preConvertToDomain((Object)"zzz", (Object)3, new String[]{"bla"})).isEqualTo((Object)PreConverter.Result.SKIP);
        ((ResultPreConverter)Mockito.verify((Object)this.first)).preConvertToDomain("zzz", 3, "bla");
        ((ResultPreConverter)Mockito.verify((Object)this.second)).preConvertToDomain("zzz", 3, "bla");
        ((ResultPreConverter)Mockito.verify((Object)this.third, (VerificationMode)Mockito.never())).preConvertToDomain("zzz", 3, "bla");
    }

    private class ResultPreConverter
    implements PreConverter<String, Integer> {
        private final PreConverter.Result result;

        public ResultPreConverter(PreConverter.Result result) {
            this.result = result;
        }

        public PreConverter.Result preConvertToTo(Integer source, String target, String ... tags) {
            return this.result;
        }

        public PreConverter.Result preConvertToDomain(String source, Integer target, String ... tags) {
            return this.result;
        }
    }
}

