/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jtransfo.MappedBy;
import org.jtransfo.NotMapped;
import org.jtransfo.ReadOnly;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.MaleHumanTo;
import org.jtransfo.object.MixedMethodAndFieldDomain;
import org.jtransfo.object.ReadOnlyAnnotationTo;
import org.jtransfo.object.SimpleBaseTo;
import org.jtransfo.object.SimpleClassDomain;
import org.jtransfo.object.SimpleExtendedDomain;
import org.junit.Before;
import org.junit.Test;

public class ReflectionHelperTest {
    private static final String REFLECTION_HELPER_CLASS = "org.jtransfo.internal.ReflectionHelper";
    private ReflectionHelper reflectionHelper;

    @Before
    public void setUp() throws Exception {
        this.reflectionHelper = new ReflectionHelper();
    }

    @Test
    public void testNewInstanceClass() throws Exception {
        Assertions.assertThat((Object)this.reflectionHelper.newInstance(ReflectionHelper.class)).isInstanceOf(ReflectionHelper.class);
    }

    @Test
    public void testNewInstanceName() throws Exception {
        Object instance = this.reflectionHelper.newInstance(REFLECTION_HELPER_CLASS);
        Assertions.assertThat((Object)instance).isInstanceOf(ReflectionHelper.class);
    }

    @Test
    public void testLoadClass() throws Exception {
        Class reflectionHelperClass = this.reflectionHelper.loadClass(REFLECTION_HELPER_CLASS);
        Assertions.assertThat((String)reflectionHelperClass.getName()).isEqualTo((Object)REFLECTION_HELPER_CLASS);
    }

    @Test
    public void testGetFields() throws Exception {
        List fields = this.reflectionHelper.getFields(SimpleExtendedDomain.class);
        ((ListAssert)Assertions.assertThat((List)fields).hasSize(4)).extracting("name").contains(new Object[]{"a", "b", "c", "i"});
    }

    @Test
    public void testMakeAccessible() throws Exception {
        Field field = SimpleClassDomain.class.getDeclaredField("bla");
        Assertions.assertThat((boolean)field.isAccessible()).isFalse();
        this.reflectionHelper.makeAccessible(field);
        Assertions.assertThat((boolean)field.isAccessible()).isTrue();
    }

    @Test
    public void testMakeSynthetic() throws Exception {
        ArrayList<Field> orgFields = new ArrayList<Field>();
        orgFields.add(SimpleExtendedDomain.class.getDeclaredField("b"));
        orgFields.add(SimpleExtendedDomain.class.getDeclaredField("c"));
        List fields = this.reflectionHelper.makeSynthetic(SimpleExtendedDomain.class, orgFields);
        Assertions.assertThat((List)fields).hasSize(2);
        for (SyntheticField sf : fields) {
            Assertions.assertThat((Object)sf).isInstanceOf(AccessorSyntheticField.class);
        }
    }

    @Test
    public void testGetSyntheticFields() throws Exception {
        List fields = this.reflectionHelper.getSyntheticFields(SimpleExtendedDomain.class);
        ((ListAssert)Assertions.assertThat((List)fields).hasSize(4)).extracting("name").contains(new Object[]{"a", "b", "c", "i"});
    }

    @Test
    public void testGetMethod() throws Exception {
        Method method = this.reflectionHelper.getMethod(SimpleBaseTo.class, null, "setA", new Class[]{String.class});
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"setA");
        method = this.reflectionHelper.getMethod(SimpleBaseTo.class, null, "setA", new Class[]{Integer.class});
        Assertions.assertThat((Object)method).isNull();
        method = this.reflectionHelper.getMethod(SimpleBaseTo.class, String.class, "getA", new Class[0]);
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"getA");
        method = this.reflectionHelper.getMethod(SimpleBaseTo.class, Integer.class, "getA", new Class[0]);
        Assertions.assertThat((Object)method).isNull();
        method = this.reflectionHelper.getMethod(SimpleBaseTo.class, Object.class, "getA", new Class[0]);
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"getA");
        method = this.reflectionHelper.getMethod(SimpleBaseTo.class, null, "bla", new Class[0]);
        Assertions.assertThat((Object)method).isNull();
    }

    @Test
    public void testGetMethod_extendedAndPrivate() throws Exception {
        Method method = this.reflectionHelper.getMethod(MaleHumanTo.class, null, "setName", new Class[]{String.class});
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"setName");
        method = this.reflectionHelper.getMethod(MixedMethodAndFieldDomain.class, String.class, "getFieldWithPrivateAccessors", new Class[0]);
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"getFieldWithPrivateAccessors");
        method = this.reflectionHelper.getMethod(MaleHumanTo.class, null, "setNameAlternate", new Class[]{String.class});
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"setNameAlternate");
        method = this.reflectionHelper.getMethod(MixedMethodAndFieldDomain.class, String.class, "getFieldDouble", new Class[0]);
        Assertions.assertThat((String)method.getName()).isEqualTo((Object)"getFieldDouble");
    }

    @Test
    public void testGetAnnotationWithMeta() throws Exception {
        ReadOnlyAnnotationTo to = new ReadOnlyAnnotationTo();
        Field field = to.getClass().getDeclaredField("twice");
        Assertions.assertThat((List)this.reflectionHelper.getAnnotationWithMeta((AnnotatedElement)field, ReadOnly.class)).hasSize(1);
        Assertions.assertThat((List)this.reflectionHelper.getAnnotationWithMeta((AnnotatedElement)field, MappedBy.class)).hasSize(1);
        Assertions.assertThat((List)this.reflectionHelper.getAnnotationWithMeta((AnnotatedElement)field, NotMapped.class)).hasSize(0);
    }
}

