/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.data.MapEntry;
import org.jtransfo.Converter;
import org.jtransfo.internal.TaggedConverter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class TaggedConverterTest {
    private static final String TAG = "key";
    private TaggedConverter taggedConverter;

    @Before
    public void setUp() throws Exception {
        this.taggedConverter = new TaggedConverter();
    }

    @Test
    public void testAddConverters() throws Exception {
        Converter c1 = (Converter)Mockito.mock(Converter.class);
        Converter c2 = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(c1, new String[]{TAG, "zzz"});
        this.taggedConverter.addConverters(c2, new String[]{TAG});
        Map res = (Map)ReflectionTestUtils.getField((Object)this.taggedConverter, (String)"converters");
        ((MapAssert)Assertions.assertThat((Map)res).hasSize(2)).contains(new MapEntry[]{MapEntry.entry((Object)"zzz", (Object)c1), MapEntry.entry((Object)TAG, (Object)c2)});
    }

    @Test
    public void testConvert() throws Exception {
        Converter starConverter = (Converter)Mockito.mock(Converter.class);
        Converter converter = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(converter, new String[]{TAG});
        this.taggedConverter.addConverters(starConverter, new String[]{"*"});
        Object source = Mockito.mock(Object.class);
        Object target = Mockito.mock(Object.class);
        this.taggedConverter.convert(source, target, new String[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{converter});
        ((Converter)Mockito.verify((Object)starConverter)).convert(source, target, new String[0]);
    }

    @Test
    public void testConvert_withTags() throws Exception {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(converter, new String[]{TAG});
        Object source = Mockito.mock(Object.class);
        Object target = Mockito.mock(Object.class);
        this.taggedConverter.convert(source, target, new String[]{TAG});
        ((Converter)Mockito.verify((Object)converter)).convert(source, target, new String[]{TAG});
    }

    @Test
    public void testConvert_withoutTags() throws Exception {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(converter, new String[]{TAG});
        Object source = Mockito.mock(Object.class);
        Object target = Mockito.mock(Object.class);
        this.taggedConverter.convert(source, target, new String[]{"bla"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{converter});
    }

    @Test
    public void testConvert_withNotTags() throws Exception {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(converter, new String[]{"!key"});
        Object source = Mockito.mock(Object.class);
        Object target = Mockito.mock(Object.class);
        this.taggedConverter.convert(source, target, new String[]{TAG});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{converter});
    }

    @Test
    public void testConvert_withoutNotTags() throws Exception {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        this.taggedConverter.addConverters(converter, new String[]{"!key"});
        Object source = Mockito.mock(Object.class);
        Object target = Mockito.mock(Object.class);
        this.taggedConverter.convert(source, target, new String[]{"bla"});
        ((Converter)Mockito.verify((Object)converter)).convert(source, target, new String[]{"bla"});
    }
}

