/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.jtransfo.AbstractToDomainTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.Named;
import org.jtransfo.NeedsJTransfo;
import org.jtransfo.ReadOnlyDomainAutomaticListTypeConverter;
import org.jtransfo.ReadOnlyDomainAutomaticSetTypeConverter;
import org.jtransfo.TagsUtil;
import org.jtransfo.internal.SyntheticField;

public class ReadOnlyDomainAutomaticTypeConverter
extends AbstractToDomainTypeConverter
implements Named,
NeedsJTransfo {
    private String name = "readOnlyDomain";
    private ReadOnlyDomainAutomaticListTypeConverter rodListTypeConverter = new ReadOnlyDomainAutomaticListTypeConverter();
    private ReadOnlyDomainAutomaticSetTypeConverter rodSetTypeConverter = new ReadOnlyDomainAutomaticSetTypeConverter();

    @Override
    public void setJTransfo(JTransfo jTransfo) {
        super.setJTransfo(jTransfo);
        this.rodListTypeConverter.setJTransfo(jTransfo);
        this.rodSetTypeConverter.setJTransfo(jTransfo);
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        return false;
    }

    @Override
    public Object convert(Object toObject, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
        if (List.class.isAssignableFrom(domainField.getType())) {
            return this.rodListTypeConverter.convert((List)toObject, domainField, domainObject, tags);
        }
        if (Set.class.isAssignableFrom(domainField.getType())) {
            return this.rodSetTypeConverter.convert((Set)toObject, domainField, domainObject, tags);
        }
        return super.convert(toObject, domainField, domainObject, tags);
    }

    @Override
    public Object reverse(Object domainObject, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
        if (List.class.isAssignableFrom(toField.getType())) {
            return this.rodListTypeConverter.reverse((List)domainObject, toField, toObject, tags);
        }
        if (Set.class.isAssignableFrom(toField.getType())) {
            return this.rodSetTypeConverter.reverse((Set)domainObject, toField, toObject, tags);
        }
        return super.reverse(domainObject, toField, toObject, tags);
    }

    @Override
    public Object doConvert(JTransfo jTransfo, Object toObject, SyntheticField domainField, String ... tags) throws JTransfoException {
        Class<?> domainType = domainField.getType();
        if (null != toObject) {
            domainType = jTransfo.getDomainClass(toObject.getClass());
        }
        return jTransfo.findTarget(toObject, domainType, TagsUtil.add(tags, "\u00a7#readOnlyDomain"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeepNullList(boolean keepNullList) {
        this.rodListTypeConverter.setKeepNullList(keepNullList);
    }

    public void setKeepNullSet(boolean keepNullSet) {
        this.rodSetTypeConverter.setKeepNullSet(keepNullSet);
    }

    public void setAlwaysNewList(boolean alwaysNewList) {
        this.rodListTypeConverter.setAlwaysNewList(alwaysNewList);
    }

    public void setAlwaysNewSet(boolean alwaysNewSet) {
        this.rodSetTypeConverter.setAlwaysNewSet(alwaysNewSet);
    }

    public void setSortList(boolean sortList) {
        this.rodListTypeConverter.setSortList(sortList);
    }
}

