/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class TypeUtil {
    private TypeUtil() {
        throw new IllegalAccessError("TypeUtil cannot be instantiated.");
    }

    public static Class<?> getRawClass(Type type) {
        Type[] bounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable && null != (bounds = ((TypeVariable)type).getBounds()) && 0 < bounds.length) {
            return TypeUtil.getRawClass(bounds[0]);
        }
        return Object.class;
    }

    public static Class<?> getFirstTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return TypeUtil.getRawClass(p.getActualTypeArguments()[0]);
        }
        return null;
    }
}

