/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jtransfo.JTransfoException;
import org.jtransfo.MapOnlies;
import org.jtransfo.MapOnly;
import org.jtransfo.MappedBy;
import org.jtransfo.Named;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.NotMapped;
import org.jtransfo.PostConvert;
import org.jtransfo.PostConverter;
import org.jtransfo.PreConvert;
import org.jtransfo.PreConverter;
import org.jtransfo.ToConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.CombinedPreConverter;
import org.jtransfo.internal.LockableList;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.TaggedConverter;
import org.jtransfo.internal.ToDomainConverter;
import org.jtransfo.internal.ToToConverter;

public class ConverterHelper {
    private static final String DECLARED_TYPE_CONVERTER_CLASS = "Declared TypeConverter class ";
    private ReflectionHelper reflectionHelper = new ReflectionHelper();
    private ConcurrentHashMap<String, TypeConverter> typeConverterInstances = new ConcurrentHashMap();
    private List<TypeConverter> typeConvertersInOrder = Collections.emptyList();
    private ConcurrentHashMap<String, PreConverter> preConverterInstances = new ConcurrentHashMap();
    private ConcurrentHashMap<String, PostConverter> postConverterInstances = new ConcurrentHashMap();

    public ToConverter getToConverter(Class toClass, Class domainClass) throws JTransfoException {
        ToConverter converter = this.withPreConverter(toClass);
        List<SyntheticField> domainFields = this.reflectionHelper.getSyntheticFields(domainClass);
        for (Field field : this.reflectionHelper.getFields(toClass)) {
            boolean isStatic;
            boolean isTransient = Modifier.isTransient(field.getModifiers());
            List<NotMapped> notMapped = this.reflectionHelper.getAnnotationWithMeta(field, NotMapped.class);
            if (isTransient || 0 != notMapped.size()) continue;
            List<MappedBy> mappedBies = this.reflectionHelper.getAnnotationWithMeta(field, MappedBy.class);
            if (mappedBies.size() > 1) {
                throw new JTransfoException("Field " + field.getName() + " on type " + field.getDeclaringClass().getName() + " MappedBy is ambiguous, check your meta-annotations.");
            }
            MappedBy mappedBy = null;
            if (1 == mappedBies.size()) {
                mappedBy = mappedBies.get(0);
            }
            boolean bl = isStatic = 0 != (field.getModifiers() & 8);
            if (0 == mappedBies.size() && isStatic) continue;
            this.buildConverters(field, domainFields, domainClass, converter, mappedBy);
        }
        this.addPostConverter(converter, toClass);
        return converter;
    }

    private SyntheticField[] getDomainField(Field field, List<SyntheticField> domainFields, Class domainClass, String fieldParam, String pathParam, boolean readOnlyParam) {
        SyntheticField[] domainField;
        boolean readOnlyField;
        String domainFieldName = field.getName();
        String[] domainFieldPath = new String[]{};
        boolean bl = readOnlyField = 0 != (field.getModifiers() & 0x10) || readOnlyParam;
        if (!"?".equals(fieldParam)) {
            domainFieldName = fieldParam;
        }
        if (!"".equals(pathParam)) {
            domainFieldPath = pathParam.split("\\.");
        }
        try {
            domainField = this.findField(domainFields, domainFieldName, domainFieldPath, domainClass, readOnlyField);
        }
        catch (JTransfoException jte) {
            throw new JTransfoException(String.format("Cannot determine mapping for field %s in class %s. The field %s in class %s %scannot be found.", field.getName(), field.getDeclaringClass().getName(), domainFieldName, domainClass.getName(), this.withPath(domainFieldPath)), jte);
        }
        return domainField;
    }

    private SyntheticField[] getDomainField(Field field, List<SyntheticField> domainFields, Class domainClass, MappedBy mappedBy) {
        if (null == mappedBy) {
            return this.getDomainField(field, domainFields, domainClass, "?", "", false);
        }
        return this.getDomainField(field, domainFields, domainClass, mappedBy.field(), mappedBy.path(), mappedBy.readOnly());
    }

    private void buildConverters(Field field, List<SyntheticField> domainFields, Class domainClass, ToConverter converter, MappedBy mappedBy) {
        SimpleSyntheticField sField = new SimpleSyntheticField(field);
        List<MapOnly> mapOnlies = this.getMapOnlies(field);
        if (null == mapOnlies) {
            SyntheticField[] domainField = this.getDomainField(field, domainFields, domainClass, mappedBy);
            TypeConverter typeConverter = this.getDeclaredTypeConverter(mappedBy);
            if (null == typeConverter) {
                typeConverter = this.getDefaultTypeConverter(field.getGenericType(), domainField[domainField.length - 1].getGenericType());
            }
            if (0 == (field.getModifiers() & 0x10)) {
                converter.getToTo().add(new ToToConverter(sField, domainField, typeConverter));
            }
            if (null == mappedBy || !mappedBy.readOnly()) {
                converter.getToDomain().add(new ToDomainConverter(sField, domainField, typeConverter));
            }
        } else {
            TaggedConverter toTo = new TaggedConverter();
            TaggedConverter toDomain = new TaggedConverter();
            converter.getToTo().add(toTo);
            converter.getToDomain().add(toDomain);
            for (MapOnly mapOnly : mapOnlies) {
                TypeConverter typeConverter;
                SyntheticField[] mapOnlyDomainField = null;
                if (!"".equals(mapOnly.path()) || !"?".equals(mapOnly.field())) {
                    mapOnlyDomainField = this.getDomainField(field, domainFields, domainClass, mapOnly.field(), mapOnly.path(), mapOnly.readOnly());
                }
                if (null == mapOnlyDomainField) {
                    mapOnlyDomainField = this.getDomainField(field, domainFields, domainClass, mappedBy);
                }
                if (null == (typeConverter = this.getDeclaredTypeConverter(mappedBy))) {
                    typeConverter = this.getDefaultTypeConverter(field.getGenericType(), mapOnlyDomainField[mapOnlyDomainField.length - 1].getGenericType());
                }
                TypeConverter moTypeConverter = this.getDeclaredTypeConverter(mapOnly, typeConverter);
                ToToConverter ttc = new ToToConverter(sField, mapOnlyDomainField, moTypeConverter);
                toTo.addConverters(ttc, mapOnly.value());
                if (mapOnly.readOnly()) continue;
                ToDomainConverter tdc = new ToDomainConverter(sField, mapOnlyDomainField, moTypeConverter);
                toDomain.addConverters(tdc, mapOnly.value());
            }
        }
    }

    private ToConverter withPreConverter(Class toClass) {
        List<PreConvert.List> preConvertListAnnotations = this.reflectionHelper.getAnnotationWithMeta(toClass, PreConvert.List.class);
        List<PreConvert> preConvertAnnotations = this.reflectionHelper.getAnnotationWithMeta(toClass, PreConvert.class);
        preConvertListAnnotations.forEach(list -> preConvertAnnotations.addAll(Arrays.asList(list.value())));
        if (preConvertAnnotations.isEmpty()) {
            return new ToConverter();
        }
        ArrayList preConverters = new ArrayList();
        for (PreConvert ann : preConvertAnnotations) {
            preConverters.add(this.getConverter(ann.value(), ann.converterClass(), this.preConverterInstances, "preConverter"));
        }
        if (preConverters.size() == 1) {
            return new ToConverter((PreConverter)preConverters.get(0));
        }
        return new ToConverter(new CombinedPreConverter(preConverters));
    }

    private void addPostConverter(ToConverter converter, Class toClass) {
        List<PostConvert.List> postConvertListAnnotations = this.reflectionHelper.getAnnotationWithMeta(toClass, PostConvert.List.class);
        List<PostConvert> postConvertAnnotations = this.reflectionHelper.getAnnotationWithMeta(toClass, PostConvert.class);
        postConvertListAnnotations.forEach(list -> postConvertAnnotations.addAll(Arrays.asList(list.value())));
        for (PostConvert ann : postConvertAnnotations) {
            PostConverter postConverter = this.getConverter(ann.value(), ann.converterClass(), this.postConverterInstances, "postConverter");
            converter.addToDomain(postConverter::postConvertToDomain);
            converter.addToTo(postConverter::postConvertToTo);
        }
    }

    private <C> C getConverter(String converterName, Class converterClass, Map<String, C> converterInstances, String typeForException) {
        C converter;
        String name = converterName;
        if ("?".equals(name)) {
            name = converterClass.getName();
        }
        if (null == (converter = converterInstances.get(name))) {
            throw new JTransfoException(String.format("Cannot find %s %s.", typeForException, name));
        }
        return converter;
    }

    List<MapOnly> getMapOnlies(Field field) {
        List<MapOnly> mapOnly = this.reflectionHelper.getAnnotationWithMeta(field, MapOnly.class);
        List<MapOnlies> mapOnlies = this.reflectionHelper.getAnnotationWithMeta(field, MapOnlies.class);
        if (0 == mapOnly.size() && 0 == mapOnlies.size()) {
            return null;
        }
        ArrayList<MapOnly> res = new ArrayList<MapOnly>();
        res.addAll(mapOnly);
        mapOnlies.forEach(mo -> Collections.addAll(res, mo.value()));
        return res;
    }

    String withPath(String[] path) {
        StringBuilder sb = new StringBuilder();
        if (path.length > 0) {
            sb.append(" (with path ");
            for (int i = 0; i < path.length - 1; ++i) {
                sb.append(path[i]);
                sb.append(".");
            }
            sb.append(path[path.length - 1]);
            sb.append(") ");
        }
        return sb.toString();
    }

    SyntheticField[] findField(List<SyntheticField> domainFields, String fieldName, String[] path, Class<?> type, boolean readOnlyField) throws JTransfoException {
        List<SyntheticField> fields = domainFields;
        SyntheticField[] result = new SyntheticField[path.length + 1];
        Class<?> currentType = type;
        for (int index = 0; index < path.length; ++index) {
            boolean found = false;
            for (SyntheticField field : fields) {
                if (!field.getName().equals(path[index])) continue;
                found = true;
                result[index] = field;
                break;
            }
            if (!found) {
                result[index] = new AccessorSyntheticField(this.reflectionHelper, currentType, path[index], readOnlyField);
            }
            currentType = result[index].getType();
            fields = this.reflectionHelper.getSyntheticFields(currentType);
        }
        for (SyntheticField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            result[index] = field;
            return result;
        }
        result[index] = new AccessorSyntheticField(this.reflectionHelper, currentType, fieldName, readOnlyField);
        return result;
    }

    TypeConverter getDeclaredTypeConverter(String typeConverterClassName1, String typeConverterClassName2) {
        String typeConverterClass = typeConverterClassName1;
        if (MappedBy.DefaultTypeConverter.class.getName().equals(typeConverterClass)) {
            typeConverterClass = typeConverterClassName2;
        }
        if (!"?".equals(typeConverterClass)) {
            TypeConverter typeConverter = this.typeConverterInstances.get(typeConverterClass);
            if (null == typeConverter) {
                try {
                    typeConverter = (TypeConverter)this.reflectionHelper.newInstance(typeConverterClass);
                    this.typeConverterInstances.put(typeConverterClass, typeConverter);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be found.", cnfe);
                }
                catch (InstantiationException ie) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be instantiated.", ie);
                }
                catch (IllegalAccessException iae) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be accessed.", iae);
                }
                catch (ClassCastException cce) {
                    throw new JTransfoException(DECLARED_TYPE_CONVERTER_CLASS + typeConverterClass + " cannot be cast to a TypeConverter.", cce);
                }
            }
            return typeConverter;
        }
        return null;
    }

    TypeConverter getDeclaredTypeConverter(MappedBy mappedBy) {
        if (null == mappedBy) {
            return null;
        }
        return this.getDeclaredTypeConverter(mappedBy.typeConverterClass().getName(), mappedBy.typeConverter());
    }

    TypeConverter getDeclaredTypeConverter(MapOnly mapOnly, TypeConverter fallback) {
        TypeConverter typeConverter;
        if (null != mapOnly && null != (typeConverter = this.getDeclaredTypeConverter(mapOnly.typeConverterClass().getName(), mapOnly.typeConverter()))) {
            return typeConverter;
        }
        return fallback;
    }

    void setTypeConvertersInOrder(Collection<TypeConverter> typeConverters) {
        LockableList<TypeConverter> newList = new LockableList<TypeConverter>();
        newList.addAll(typeConverters);
        newList.lock();
        this.typeConvertersInOrder = newList;
        for (TypeConverter tc : newList) {
            String name = null;
            if (tc instanceof Named) {
                name = ((Named)((Object)tc)).getName();
            }
            if (null == name) {
                name = tc.getClass().getName();
            }
            this.typeConverterInstances.put(name, tc);
        }
    }

    TypeConverter getDefaultTypeConverter(Type toField, Type domainField) {
        for (TypeConverter typeConverter : this.typeConvertersInOrder) {
            if (!typeConverter.canConvert(toField, domainField)) continue;
            return typeConverter;
        }
        return new NoConversionTypeConverter();
    }

    void setPreConverters(Collection<PreConverter> preConverters) {
        for (PreConverter pc : preConverters) {
            if (pc instanceof Named) {
                this.preConverterInstances.put(((Named)((Object)pc)).getName(), pc);
            }
            this.preConverterInstances.put(pc.getClass().getName(), pc);
        }
    }

    void setPostConverters(Collection<PostConverter> postConverters) {
        for (PostConverter pc : postConverters) {
            if (pc instanceof Named) {
                this.postConverterInstances.put(((Named)((Object)pc)).getName(), pc);
            }
            this.postConverterInstances.put(pc.getClass().getName(), pc);
        }
    }
}

