/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.HashMap;
import java.util.Map;
import org.jtransfo.Converter;
import org.jtransfo.JTransfoException;

public class TaggedConverter
implements Converter {
    private Map<String, Converter> converters = new HashMap<String, Converter>();
    private Map<String, Converter> notConverters = new HashMap<String, Converter>();

    public void addConverters(Converter converter, String ... tags) {
        for (String tag : tags) {
            if (tag.startsWith("!")) {
                this.notConverters.put(tag.substring(1), converter);
                continue;
            }
            this.converters.put(tag, converter);
        }
    }

    @Override
    public void convert(Object source, Object target, String ... tags) throws JTransfoException {
        Converter converter = this.converters.get("*");
        if (null != converter) {
            converter.convert(source, target, tags);
        }
        if (!this.notConverters.isEmpty()) {
            for (Map.Entry entry : this.notConverters.entrySet()) {
                if (this.contains(tags, (String)entry.getKey())) continue;
                ((Converter)entry.getValue()).convert(source, target, tags);
            }
        }
        if (null != tags) {
            for (String tag : tags) {
                converter = this.converters.get(tag);
                if (null == converter) continue;
                converter.convert(source, target, tags);
            }
        }
    }

    private boolean contains(String[] tags, String key) {
        for (String tag : tags) {
            if (!key.equals(tag)) continue;
            return true;
        }
        return false;
    }
}

