/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.demo.domain;

import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.ForeignKey;
import org.jtransfo.demo.domain.Address;
import org.jtransfo.demo.domain.VoiceContact;

@Entity(name="person")
@SequenceGenerator(name="seq", sequenceName="person_seq")
public class Person
implements Comparable<Person> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq")
    private Long id;
    @Basic
    private String name;
    @ManyToOne(cascade={CascadeType.ALL}, optional=true, fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumn
    @ForeignKey(name="person_address")
    private Address address;
    @Basic
    private String comment;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=false)
    @JoinColumn(name="person_id")
    @ForeignKey(name="person_voiceContact")
    private List<VoiceContact> voiceContacts;

    @Override
    public int compareTo(Person other) {
        return this.name.compareTo(other.name);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getComment() {
        return this.comment;
    }

    public List<VoiceContact> getVoiceContacts() {
        return this.voiceContacts;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setVoiceContacts(List<VoiceContact> voiceContacts) {
        this.voiceContacts = voiceContacts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<VoiceContact> this$voiceContacts = this.getVoiceContacts();
        List<VoiceContact> other$voiceContacts = other.getVoiceContacts();
        return !(this$voiceContacts == null ? other$voiceContacts != null : !((Object)this$voiceContacts).equals(other$voiceContacts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Person;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<VoiceContact> $voiceContacts = this.getVoiceContacts();
        result = result * 59 + ($voiceContacts == null ? 43 : ((Object)$voiceContacts).hashCode());
        return result;
    }

    public String toString() {
        return "Person(id=" + this.getId() + ", name=" + this.getName() + ", address=" + this.getAddress() + ", comment=" + this.getComment() + ", voiceContacts=" + this.getVoiceContacts() + ")";
    }
}

