/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.demo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hibernate.SessionFactory;
import org.jtransfo.JTransfo;
import org.jtransfo.demo.domain.AddressTo;
import org.jtransfo.demo.domain.Country;
import org.jtransfo.demo.domain.Person;
import org.jtransfo.demo.domain.PersonTo;
import org.jtransfo.demo.domain.VoiceContact;
import org.jtransfo.demo.domain.VoiceContactTo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"applicationContext.xml"})
public class JTransfoAndHibernateTest {
    private static final Long PERSON_ID = 1000L;
    private static final Long ADDRESS_ID = 2000L;
    @Autowired
    private JTransfo jTransfo;
    @Autowired
    private SessionFactory sessionFactory;

    @Test
    @Transactional
    public void convertDatabaseObjectToTransfer() throws Exception {
        Person person = (Person)this.sessionFactory.getCurrentSession().get(Person.class, (Serializable)PERSON_ID);
        Assertions.assertThat((Object)person).isNotNull();
        PersonTo to = (PersonTo)this.jTransfo.convert((Object)person, (Object)new PersonTo(), new String[0]);
        Assertions.assertThat((Object)to).isNotNull();
        Assertions.assertThat((Long)to.getId()).isEqualTo((Object)PERSON_ID);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)"John Doe");
        AddressTo address = to.getAddress();
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((Long)address.getId()).isEqualTo((Object)ADDRESS_ID);
        Assertions.assertThat((String)address.getAddress()).isEqualTo((Object)"Churchstreet 11");
        Assertions.assertThat((String)address.getPostalCode()).isEqualTo((Object)"1234");
        Assertions.assertThat((String)address.getLocation()).isEqualTo((Object)"Mytown");
        Assertions.assertThat((String)address.getCountry()).isEqualTo((Object)"BE");
        List voiceContacts = to.getVoiceContacts();
        Assertions.assertThat((List)voiceContacts).isNotNull();
        ((ListAssert)Assertions.assertThat((List)voiceContacts).hasSize(2)).extracting("type").contains(new Object[]{"work", "private, skype"});
        for (Object obj : voiceContacts) {
            Assertions.assertThat(obj).isInstanceOf(VoiceContactTo.class);
        }
    }

    @Test
    @Transactional
    public void convertTransferObjectToDatabase() throws Exception {
        PersonTo personTo = new PersonTo();
        AddressTo addressTo = new AddressTo();
        personTo.setId(PERSON_ID);
        personTo.setName("Peter Gabriel");
        personTo.setAddress(addressTo);
        personTo.setComment("Clear!");
        addressTo.setAddress("Salsbury Hill");
        addressTo.setPostalCode("zzz");
        addressTo.setLocation("Batheaston");
        addressTo.setCountry(Country.GB.name());
        ArrayList<VoiceContactTo> voiceContacts = new ArrayList<VoiceContactTo>();
        VoiceContactTo vc = new VoiceContactTo();
        vc.setType("home");
        vc.setVoice("+32 3 123 45 78");
        voiceContacts.add(vc);
        personTo.setVoiceContacts(voiceContacts);
        Person person = (Person)this.jTransfo.convert((Object)personTo);
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Peter Gabriel");
        Assertions.assertThat((String)person.getComment()).isEqualTo((Object)"db-only info");
        Assertions.assertThat((Object)person.getAddress()).isNotNull();
        Assertions.assertThat((String)person.getAddress().getAddress()).isEqualTo((Object)"Salsbury Hill");
        Assertions.assertThat((String)person.getAddress().getPostalCode()).isEqualTo((Object)"zzz");
        Assertions.assertThat((String)person.getAddress().getLocation()).isEqualTo((Object)"Batheaston");
        Assertions.assertThat((Object)person.getAddress().getCountry()).isEqualTo((Object)Country.GB);
        ((ListAssert)Assertions.assertThat((List)person.getVoiceContacts()).hasSize(1)).extracting("type").contains(new Object[]{"home"});
        for (Object obj : person.getVoiceContacts()) {
            Assertions.assertThat(obj).isInstanceOf(VoiceContact.class);
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)person);
    }
}

