/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.spring.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.PathImpl;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.ConvertSourceTarget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.MapBindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

@Component
public class BeanValidationConvertInterceptor
implements ConvertInterceptor {
    @Autowired
    private SpringValidatorAdapter validator;

    public <T> T convert(Object source, T target, boolean isTargetTo, ConvertSourceTarget next, String ... tags) {
        Object res = next.convert(source, target, isTargetTo, tags);
        if (!isTargetTo) {
            MapBindingResult bindingResult = new MapBindingResult(new HashMap(), "");
            this.validator.validate(res, (Errors)bindingResult);
            if (bindingResult.hasErrors()) {
                HashSet<ConstraintViolationImpl> violations = new HashSet<ConstraintViolationImpl>();
                for (ObjectError error : bindingResult.getAllErrors()) {
                    violations.add(new ConstraintViolationImpl(error.getDefaultMessage(), error.getDefaultMessage(), res.getClass(), res, res, res, (Path)PathImpl.createPathFromString((String)error.getObjectName()), null, null));
                }
                throw new MyConstraintViolationException(violations);
            }
        }
        return (T)res;
    }

    private static class MyConstraintViolationException
    extends ConstraintViolationException {
        private MyConstraintViolationException(Set<ConstraintViolation<?>> constraintViolations) {
            super(constraintViolations);
        }

        public String getMessage() {
            return this.toString();
        }

        public String toString() {
            return "ConstraintViolationException " + this.getConstraintViolations();
        }
    }
}

