/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.spring;

import java.util.Date;
import javax.validation.ConstraintViolationException;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.spring.domain.PersonDomain;
import org.jtransfo.spring.domain.PersonTo;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/jtransfo/spring/jTransfoContext.xml", "testContext.xml"})
public class JTransfoSpringCustomizedTest {
    private static final String NAME = "ikke";
    @Autowired
    private JTransfo jTransfo;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testWithFinderAndConverterAndInterceptorsToDomain() throws Exception {
        PersonTo to = new PersonTo();
        to.setGender("MALE");
        to.setLastChanged(new Date());
        to.setName(NAME);
        to.setAddress(new AddressTo(Long.valueOf(3L)));
        PersonDomain domain = (PersonDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Date)domain.getLastChanged()).isNotNull();
        Assertions.assertThat((long)domain.getLastChanged().getTime()).isGreaterThan(System.currentTimeMillis() - 5000L);
        Assertions.assertThat((String)domain.getExtra()).isEqualTo((Object)"Extra sleep.");
    }

    @Test
    public void testValidation() throws Exception {
        PersonTo to = new PersonTo();
        to.setGender("MALE");
        to.setLastChanged(new Date());
        to.setName(null);
        to.setAddress(new AddressTo(Long.valueOf(3L)));
        this.exception.expect(ConstraintViolationException.class);
        this.exception.expectMessage("interpolatedMessage='may not be null'");
        this.jTransfo.convert((Object)to);
    }

    @Test
    public void testWithFinderAndConverterToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        Date now = new Date();
        domain.setLastChanged(now);
        AddressDomain address = new AddressDomain();
        address.setId(Long.valueOf(7L));
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        PersonTo to = (PersonTo)this.jTransfo.convert((Object)domain, (Object)new PersonTo(), new String[0]);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Date)to.getLastChanged()).isEqualTo((Object)now);
    }
}

