/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jtransfo.ConfigurableJTransfo;
import org.jtransfo.ConvertInterceptor;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoFactory;
import org.jtransfo.ObjectFinder;
import org.jtransfo.ObjectReplacer;
import org.jtransfo.TypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class JTransfoSpringFactory {
    @Autowired(required=false)
    private List<ObjectFinder> objectFinders;
    @Autowired(required=false)
    private List<TypeConverter> typeConverters;
    @Autowired(required=false)
    private List<ConvertInterceptor> convertInterceptors;
    @Autowired(required=false)
    private List<ObjectReplacer> objectReplacers;

    public JTransfo get() {
        ConfigurableJTransfo jTransfo = JTransfoFactory.get();
        if (null != this.typeConverters) {
            jTransfo.getTypeConverters().addAll(this.typeConverters);
            jTransfo.updateTypeConverters();
        }
        if (null != this.objectFinders) {
            jTransfo.getObjectFinders().addAll(this.objectFinders);
            jTransfo.updateObjectFinders();
        }
        if (null != this.convertInterceptors) {
            Collections.sort(this.convertInterceptors, new AnnotationAwareOrderComparator());
            jTransfo.getConvertInterceptors().addAll(this.convertInterceptors);
            jTransfo.updateConvertInterceptors();
        }
        if (null != this.objectReplacers) {
            ArrayList<ObjectReplacer> orderedInterceptors = new ArrayList<ObjectReplacer>();
            for (ObjectReplacer objectClassDeterminator : this.objectReplacers) {
                orderedInterceptors.add(objectClassDeterminator);
            }
            Collections.sort(orderedInterceptors, new AnnotationAwareOrderComparator());
            jTransfo.getObjectReplacers().addAll(orderedInterceptors);
            jTransfo.updateObjectReplacers();
        }
        return jTransfo;
    }
}

