/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt;

public enum AlgorithmFamily {
    HMAC,
    RSA,
    EC;


    public static AlgorithmFamily forName(String name) {
        if (HMAC.name().equalsIgnoreCase(name)) {
            return HMAC;
        }
        if (RSA.name().equalsIgnoreCase(name)) {
            return RSA;
        }
        if (EC.name().equalsIgnoreCase(name) || "ECDSA".equalsIgnoreCase(name) || "Elliptic Curve".equalsIgnoreCase(name)) {
            return EC;
        }
        String msg = "Unrecognized algorithm family name value: " + name;
        throw new IllegalArgumentException(msg);
    }
}

