/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.lang.Assert;
import java.util.function.Function;

public abstract class ClaimValueResolver<T>
implements Function<Claims, T> {
    private final boolean resultRequired;
    private final Function<Claims, ?> delegate;

    public ClaimValueResolver(Function<Claims, ?> delegate, boolean resultRequired) {
        Assert.notNull(delegate, (String)"delegate function cannot be null.");
        this.delegate = delegate;
        this.resultRequired = resultRequired;
    }

    @Override
    public T apply(Claims claims) {
        Object v = this.delegate.apply(claims);
        if (v == null) {
            if (this.resultRequired) {
                this.illegal(claims);
            }
            return this.onNullValue();
        }
        return this.toTypedValue(v, claims);
    }

    protected T onNullValue() {
        return null;
    }

    protected abstract T toTypedValue(Object var1, Claims var2);

    protected void illegal(Claims claims) {
        String msg = "Could not obtain value from claims {" + claims + "} using delegate: " + this.delegate;
        throw new IllegalArgumentException(msg);
    }
}

