/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;

public class FallbackSigningKeyResolver
extends SigningKeyResolverAdapter {
    private final SigningKeyResolver delegate;
    private final Key fallbackKey;

    public FallbackSigningKeyResolver(SigningKeyResolver delegate, Key fallbackKey) {
        Assert.notNull((Object)delegate, (String)"SigningKeyResolver argument cannot be null.");
        Assert.notNull((Object)fallbackKey, (String)"fallbackKey argument cannot be null.");
        this.delegate = delegate;
        this.fallbackKey = fallbackKey;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        Key result = this.delegate.resolveSigningKey(header, claims);
        if (result == null) {
            result = this.fallbackKey;
        }
        return result;
    }
}

